/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.metrics.eventstream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsPoller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixMetricsStreamServlet
extends HttpServlet {
    private static final long serialVersionUID = -7548505095303313237L;
    private static final Logger logger = LoggerFactory.getLogger(HystrixMetricsStreamServlet.class);
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.stream.maxConcurrentConnections", 5);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block14: {
            int numberConnections = concurrentConnections.incrementAndGet();
            int delay = 500;
            try {
                String d = request.getParameter("delay");
                if (d != null) {
                    delay = Integer.parseInt(d);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            HystrixMetricsPoller poller = null;
            try {
                if (numberConnections > maxConcurrentConnections.get()) {
                    response.sendError(503, "MaxConcurrentConnections reached: " + maxConcurrentConnections.get());
                    break block14;
                }
                response.setHeader("Content-Type", "text/event-stream");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                poller = new HystrixMetricsPoller(delay);
                MetricJsonListener jsonListener = new MetricJsonListener();
                poller.start(jsonListener);
                logger.info("Starting poller");
                try {
                    while (poller.isRunning()) {
                        List<String> jsonMessages = jsonListener.getJsonMetrics();
                        for (String json : jsonMessages) {
                            response.getWriter().println("data: " + json + "\n");
                        }
                        response.flushBuffer();
                        Thread.sleep(delay);
                    }
                }
                catch (Exception e) {
                    poller.stop();
                    logger.error("Failed to write. Will stop polling.", (Throwable)e);
                }
                logger.debug("Stopping Turbine stream to connection");
            }
            catch (Exception e) {
                logger.error("Error initializing servlet for metrics event stream.", (Throwable)e);
            }
            finally {
                concurrentConnections.decrementAndGet();
                if (poller != null) {
                    poller.stop();
                }
            }
        }
    }

    @ThreadSafe
    private static class MetricJsonListener
    implements HystrixMetricsPoller.MetricsAsJsonPollerListener {
        private final LinkedBlockingQueue<String> jsonMetrics = new LinkedBlockingQueue(1000);

        private MetricJsonListener() {
        }

        @Override
        public void handleJsonMetric(String json) {
            this.jsonMetrics.add(json);
        }

        public List<String> getJsonMetrics() {
            ArrayList<String> metrics = new ArrayList<String>();
            this.jsonMetrics.drainTo(metrics);
            return metrics;
        }
    }
}

