/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.metrics.eventstream;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixMetricsPoller {
    static final Logger logger = LoggerFactory.getLogger(HystrixMetricsPoller.class);
    private final ScheduledExecutorService executor;
    private final int delay;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> scheduledTask = null;
    private final MetricsAsJsonPollerListener listener;
    private final Object finalizerGuardian = new Object(){

        protected void finalize() throws Throwable {
            if (!HystrixMetricsPoller.this.executor.isShutdown()) {
                logger.warn(HystrixMetricsPoller.class.getSimpleName() + " was not shutdown. Caught in Finalize Guardian and shutting down.");
                try {
                    HystrixMetricsPoller.this.shutdown();
                }
                catch (Exception e) {
                    logger.error("Failed to shutdown " + HystrixMetricsPoller.class.getSimpleName(), (Throwable)e);
                }
            }
        }
    };

    public HystrixMetricsPoller(MetricsAsJsonPollerListener listener, int delay) {
        this.listener = listener;
        this.executor = new ScheduledThreadPoolExecutor(1, new MetricsPollerThreadFactory());
        this.delay = delay;
    }

    public synchronized void start() {
        if (this.running.compareAndSet(false, true)) {
            logger.info("Starting HystrixMetricsPoller");
            try {
                this.scheduledTask = this.executor.scheduleWithFixedDelay(new MetricsPoller(this.listener), 0L, this.delay, TimeUnit.MILLISECONDS);
            }
            catch (Throwable ex) {
                logger.error("Exception while creating the MetricsPoller task");
                ex.printStackTrace();
                this.running.set(false);
            }
        }
    }

    public synchronized void pause() {
        if (this.running.compareAndSet(true, false)) {
            logger.info("Stopping the HystrixMetricsPoller");
            this.scheduledTask.cancel(true);
        } else {
            logger.debug("Attempted to pause a stopped poller");
        }
    }

    public synchronized void shutdown() {
        this.pause();
        this.executor.shutdown();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public static class UnitTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testStartStopStart() {
            final AtomicInteger metricsCount = new AtomicInteger();
            HystrixMetricsPoller poller = new HystrixMetricsPoller(new MetricsAsJsonPollerListener(){

                @Override
                public void handleJsonMetric(String json) {
                    System.out.println("Received: " + json);
                    metricsCount.incrementAndGet();
                }
            }, 100);
            try {
                HystrixCommand<Boolean> test = new HystrixCommand<Boolean>(HystrixCommandGroupKey.Factory.asKey((String)"HystrixMetricsPollerTest")){

                    protected Boolean run() {
                        return true;
                    }
                };
                test.execute();
                poller.start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int v1 = metricsCount.get();
                Assert.assertTrue((v1 > 0 ? 1 : 0) != 0);
                poller.pause();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int v2 = metricsCount.get();
                Assert.assertTrue((v2 == v1 ? 1 : 0) != 0);
                poller.start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int v3 = metricsCount.get();
                Assert.assertTrue((v3 > v1 ? 1 : 0) != 0);
            }
            finally {
                poller.shutdown();
            }
        }
    }

    private class MetricsPollerThreadFactory
    implements ThreadFactory {
        private static final String MetricsThreadName = "HystrixMetricPoller";
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private MetricsPollerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName(MetricsThreadName);
            return thread;
        }
    }

    private class MetricsPoller
    implements Runnable {
        private final MetricsAsJsonPollerListener listener;
        private final JsonFactory jsonFactory = new JsonFactory();

        public MetricsPoller(MetricsAsJsonPollerListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                String jsonString;
                for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
                    jsonString = this.getCommandJson(commandMetrics);
                    this.listener.handleJsonMetric(jsonString);
                }
                for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                    jsonString = this.getThreadPoolJson(threadPoolMetrics);
                    this.listener.handleJsonMetric(jsonString);
                }
                for (HystrixCollapserMetrics collapserMetrics : HystrixCollapserMetrics.getInstances()) {
                    jsonString = this.getCollapserJson(collapserMetrics);
                    this.listener.handleJsonMetric(jsonString);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to output metrics as JSON", (Throwable)e);
                HystrixMetricsPoller.this.pause();
                return;
            }
        }

        private String getCommandJson(HystrixCommandMetrics commandMetrics) throws IOException {
            HystrixCommandKey key = commandMetrics.getCommandKey();
            HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key);
            StringWriter jsonString = new StringWriter();
            JsonGenerator json = this.jsonFactory.createJsonGenerator((Writer)jsonString);
            json.writeStartObject();
            json.writeStringField("type", "HystrixCommand");
            json.writeStringField("name", key.name());
            json.writeStringField("group", commandMetrics.getCommandGroup().name());
            json.writeNumberField("currentTime", System.currentTimeMillis());
            if (circuitBreaker == null) {
                json.writeBooleanField("isCircuitBreakerOpen", false);
            } else {
                json.writeBooleanField("isCircuitBreakerOpen", circuitBreaker.isOpen());
            }
            HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
            json.writeNumberField("errorPercentage", healthCounts.getErrorPercentage());
            json.writeNumberField("errorCount", healthCounts.getErrorCount());
            json.writeNumberField("requestCount", healthCounts.getTotalRequests());
            json.writeNumberField("rollingCountBadRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.BAD_REQUEST));
            json.writeNumberField("rollingCountCollapsedRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSED));
            json.writeNumberField("rollingCountEmit", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EMIT));
            json.writeNumberField("rollingCountExceptionsThrown", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            json.writeNumberField("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            json.writeNumberField("rollingCountEmit", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_EMIT));
            json.writeNumberField("rollingCountFallbackFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            json.writeNumberField("rollingCountFallbackRejection", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            json.writeNumberField("rollingCountFallbackSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            json.writeNumberField("rollingCountResponsesFromCache", commandMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            json.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            json.writeNumberField("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            json.writeNumberField("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            json.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            json.writeNumberField("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            json.writeNumberField("currentConcurrentExecutionCount", commandMetrics.getCurrentConcurrentExecutionCount());
            json.writeNumberField("rollingMaxConcurrentExecutionCount", commandMetrics.getRollingMaxConcurrentExecutions());
            json.writeNumberField("latencyExecute_mean", commandMetrics.getExecutionTimeMean());
            json.writeObjectFieldStart("latencyExecute");
            json.writeNumberField("0", commandMetrics.getExecutionTimePercentile(0.0));
            json.writeNumberField("25", commandMetrics.getExecutionTimePercentile(25.0));
            json.writeNumberField("50", commandMetrics.getExecutionTimePercentile(50.0));
            json.writeNumberField("75", commandMetrics.getExecutionTimePercentile(75.0));
            json.writeNumberField("90", commandMetrics.getExecutionTimePercentile(90.0));
            json.writeNumberField("95", commandMetrics.getExecutionTimePercentile(95.0));
            json.writeNumberField("99", commandMetrics.getExecutionTimePercentile(99.0));
            json.writeNumberField("99.5", commandMetrics.getExecutionTimePercentile(99.5));
            json.writeNumberField("100", commandMetrics.getExecutionTimePercentile(100.0));
            json.writeEndObject();
            json.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
            json.writeObjectFieldStart("latencyTotal");
            json.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
            json.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
            json.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
            json.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
            json.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
            json.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
            json.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
            json.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
            json.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
            json.writeEndObject();
            HystrixCommandProperties commandProperties = commandMetrics.getProperties();
            json.writeNumberField("propertyValue_circuitBreakerRequestVolumeThreshold", ((Integer)commandProperties.circuitBreakerRequestVolumeThreshold().get()).intValue());
            json.writeNumberField("propertyValue_circuitBreakerSleepWindowInMilliseconds", ((Integer)commandProperties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
            json.writeNumberField("propertyValue_circuitBreakerErrorThresholdPercentage", ((Integer)commandProperties.circuitBreakerErrorThresholdPercentage().get()).intValue());
            json.writeBooleanField("propertyValue_circuitBreakerForceOpen", ((Boolean)commandProperties.circuitBreakerForceOpen().get()).booleanValue());
            json.writeBooleanField("propertyValue_circuitBreakerForceClosed", ((Boolean)commandProperties.circuitBreakerForceClosed().get()).booleanValue());
            json.writeBooleanField("propertyValue_circuitBreakerEnabled", ((Boolean)commandProperties.circuitBreakerEnabled().get()).booleanValue());
            json.writeStringField("propertyValue_executionIsolationStrategy", ((HystrixCommandProperties.ExecutionIsolationStrategy)commandProperties.executionIsolationStrategy().get()).name());
            json.writeNumberField("propertyValue_executionIsolationThreadTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
            json.writeNumberField("propertyValue_executionTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
            json.writeBooleanField("propertyValue_executionIsolationThreadInterruptOnTimeout", ((Boolean)commandProperties.executionIsolationThreadInterruptOnTimeout().get()).booleanValue());
            json.writeStringField("propertyValue_executionIsolationThreadPoolKeyOverride", (String)commandProperties.executionIsolationThreadPoolKeyOverride().get());
            json.writeNumberField("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
            json.writeNumberField("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
            json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)commandProperties.metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
            json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)commandProperties.requestCacheEnabled().get()).booleanValue());
            json.writeBooleanField("propertyValue_requestLogEnabled", ((Boolean)commandProperties.requestLogEnabled().get()).booleanValue());
            json.writeNumberField("reportingHosts", 1);
            json.writeEndObject();
            json.close();
            return jsonString.getBuffer().toString();
        }

        private String getThreadPoolJson(HystrixThreadPoolMetrics threadPoolMetrics) throws IOException {
            HystrixThreadPoolKey key = threadPoolMetrics.getThreadPoolKey();
            StringWriter jsonString = new StringWriter();
            JsonGenerator json = this.jsonFactory.createJsonGenerator((Writer)jsonString);
            json.writeStartObject();
            json.writeStringField("type", "HystrixThreadPool");
            json.writeStringField("name", key.name());
            json.writeNumberField("currentTime", System.currentTimeMillis());
            json.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
            json.writeNumberField("currentCompletedTaskCount", threadPoolMetrics.getCurrentCompletedTaskCount().longValue());
            json.writeNumberField("currentCorePoolSize", threadPoolMetrics.getCurrentCorePoolSize().intValue());
            json.writeNumberField("currentLargestPoolSize", threadPoolMetrics.getCurrentLargestPoolSize().intValue());
            json.writeNumberField("currentMaximumPoolSize", threadPoolMetrics.getCurrentMaximumPoolSize().intValue());
            json.writeNumberField("currentPoolSize", threadPoolMetrics.getCurrentPoolSize().intValue());
            json.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
            json.writeNumberField("currentTaskCount", threadPoolMetrics.getCurrentTaskCount().longValue());
            json.writeNumberField("rollingCountThreadsExecuted", threadPoolMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_EXECUTION));
            json.writeNumberField("rollingMaxActiveThreads", threadPoolMetrics.getRollingMaxActiveThreads());
            json.writeNumberField("rollingCountCommandRejections", threadPoolMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            json.writeNumberField("propertyValue_queueSizeRejectionThreshold", ((Integer)threadPoolMetrics.getProperties().queueSizeRejectionThreshold().get()).intValue());
            json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)threadPoolMetrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
            json.writeNumberField("reportingHosts", 1);
            json.writeEndObject();
            json.close();
            return jsonString.getBuffer().toString();
        }

        private String getCollapserJson(HystrixCollapserMetrics collapserMetrics) throws IOException {
            HystrixCollapserKey key = collapserMetrics.getCollapserKey();
            StringWriter jsonString = new StringWriter();
            JsonGenerator json = this.jsonFactory.createJsonGenerator((Writer)jsonString);
            json.writeStartObject();
            json.writeStringField("type", "HystrixCollapser");
            json.writeStringField("name", key.name());
            json.writeNumberField("currentTime", System.currentTimeMillis());
            json.writeNumberField("rollingCountRequestsBatched", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED));
            json.writeNumberField("rollingCountBatches", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSER_BATCH));
            json.writeNumberField("rollingCountResponsesFromCache", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            json.writeNumberField("batchSize_mean", collapserMetrics.getBatchSizeMean());
            json.writeObjectFieldStart("batchSize");
            json.writeNumberField("25", collapserMetrics.getBatchSizePercentile(25.0));
            json.writeNumberField("50", collapserMetrics.getBatchSizePercentile(50.0));
            json.writeNumberField("75", collapserMetrics.getBatchSizePercentile(75.0));
            json.writeNumberField("90", collapserMetrics.getBatchSizePercentile(90.0));
            json.writeNumberField("95", collapserMetrics.getBatchSizePercentile(95.0));
            json.writeNumberField("99", collapserMetrics.getBatchSizePercentile(99.0));
            json.writeNumberField("99.5", collapserMetrics.getBatchSizePercentile(99.5));
            json.writeNumberField("100", collapserMetrics.getBatchSizePercentile(100.0));
            json.writeEndObject();
            json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)collapserMetrics.getProperties().requestCacheEnabled().get()).booleanValue());
            json.writeNumberField("propertyValue_maxRequestsInBatch", ((Integer)collapserMetrics.getProperties().maxRequestsInBatch().get()).intValue());
            json.writeNumberField("propertyValue_timerDelayInMilliseconds", ((Integer)collapserMetrics.getProperties().timerDelayInMilliseconds().get()).intValue());
            json.writeNumberField("reportingHosts", 1);
            json.writeEndObject();
            json.close();
            return jsonString.getBuffer().toString();
        }
    }

    public static interface MetricsAsJsonPollerListener {
        public void handleJsonMetric(String var1);
    }
}

