/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.spectator.impl.Preconditions;
import iep.com.netflix.iep.http.ClientConfig;
import iep.com.netflix.iep.http.Server;
import iep.com.netflix.iep.http.ServerEntry;
import iep.com.netflix.iep.http.ServerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class EurekaServerRegistry
implements ServerRegistry {
    private static final long EXPIRATION_TIME = TimeUnit.SECONDS.toMillis(15L);
    private final ConcurrentHashMap<String, ServerEntry> serversByVip = new ConcurrentHashMap();
    private final DiscoveryClient client;

    @Inject
    public EurekaServerRegistry(DiscoveryClient discoveryClient) {
        this.client = discoveryClient;
    }

    @Override
    public boolean isStillAvailable(Server server) {
        List list = this.client.getInstancesById(server.id());
        for (InstanceInfo instanceInfo : list) {
            if (instanceInfo.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Server> getServers(String string, ClientConfig clientConfig) {
        Preconditions.checkNotNull((Object)string, (String)"vipAddress");
        long l = System.currentTimeMillis();
        ServerEntry serverEntry = this.serversByVip.get(string);
        if (serverEntry == null || l - serverEntry.ctime() > EXPIRATION_TIME) {
            serverEntry = new ServerEntry(this.getServersImpl(string, clientConfig), l);
            this.serversByVip.put(string, serverEntry);
        }
        return this.next(string, serverEntry, clientConfig);
    }

    private List<Server> next(String string, ServerEntry serverEntry, ClientConfig clientConfig) {
        int n = clientConfig.numRetries() + 1;
        List<Server> list = serverEntry.next(n);
        if (list.isEmpty()) {
            throw new IllegalStateException("no UP servers for vip: " + string);
        }
        return list;
    }

    private List<Server> getServersImpl(String string, ClientConfig clientConfig) {
        List list = this.client.getInstancesByVipAddress(string, clientConfig.isSecure());
        ArrayList<Server> arrayList = new ArrayList<Server>(list.size());
        for (InstanceInfo instanceInfo : list) {
            if (instanceInfo.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
            arrayList.add(EurekaServerRegistry.toServer(clientConfig, instanceInfo));
        }
        Collections.shuffle(arrayList);
        return arrayList;
    }

    static Server toServer(ClientConfig clientConfig, InstanceInfo instanceInfo) {
        String string = clientConfig.useIpAddress() ? instanceInfo.getIPAddr() : instanceInfo.getHostName();
        int n = clientConfig.isSecure() ? instanceInfo.getSecurePort() : instanceInfo.getPort();
        int n2 = clientConfig.port(n);
        return new Server(instanceInfo.getId(), string, n2, clientConfig.isSecure());
    }
}

