/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import iep.com.netflix.iep.http.ClientConfig;
import iep.com.netflix.iep.http.RequestContext;
import iep.com.netflix.iep.http.RxHttp;
import iep.com.netflix.iep.http.Server;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import java.net.URI;
import rx.Observable;
import rx.functions.Func1;

class RedirectHandler
implements Func1<HttpClientResponse<ByteBuf>, Observable<HttpClientResponse<ByteBuf>>> {
    private final RequestContext context;
    private int redirect;

    RedirectHandler(RequestContext requestContext) {
        this.context = requestContext;
    }

    public Observable<HttpClientResponse<ByteBuf>> call(HttpClientResponse<ByteBuf> httpClientResponse) {
        Observable<HttpClientResponse<ByteBuf>> observable;
        int n = httpClientResponse.getStatus().code();
        if (n > 300 && n <= 307 && n != 304) {
            HttpClientRequest<ByteBuf> httpClientRequest = this.context.request();
            httpClientResponse.getContent().subscribe();
            URI uRI = URI.create(httpClientResponse.getHeaders().get("Location"));
            this.context.entry().withRedirect(uRI);
            if (uRI.isAbsolute()) {
                boolean bl = this.context.server().isSecure() || "https".equals(uRI.getScheme());
                Server server = new Server(uRI.getHost(), RxHttp.getPort(uRI), bl);
                HttpClientRequest<ByteBuf> httpClientRequest2 = RxHttp.copy(httpClientRequest, ClientConfig.relative(uRI));
                observable = this.context.rxHttp().execute(this.context.withRequest(httpClientRequest2).withServer(server));
            } else {
                HttpClientRequest<ByteBuf> httpClientRequest3 = RxHttp.copy(httpClientRequest, ClientConfig.relative(uRI));
                observable = this.context.rxHttp().execute(this.context.withRequest(httpClientRequest3));
            }
            ++this.redirect;
            if (this.redirect < this.context.config().followRedirects()) {
                observable = observable.flatMap((Func1)this);
            }
        } else {
            observable = Observable.just(httpClientResponse);
        }
        return observable;
    }
}

