/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.channel;

import iep.io.reactivex.netty.channel.ByteTransformer;
import iep.io.reactivex.netty.channel.ChannelMetricEventProvider;
import iep.io.reactivex.netty.channel.ChannelWriter;
import iep.io.reactivex.netty.channel.ContentTransformer;
import iep.io.reactivex.netty.channel.IdentityTransformer;
import iep.io.reactivex.netty.channel.StringTransformer;
import iep.io.reactivex.netty.metrics.Clock;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import iep.io.reactivex.netty.util.MultipleFutureListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.FileRegion;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

public class DefaultChannelWriter<O>
implements ChannelWriter<O> {
    protected static final Observable<Void> CONNECTION_ALREADY_CLOSED = Observable.error((Throwable)new IllegalStateException("Connection is already closed."));
    protected final AtomicBoolean closeIssued = new AtomicBoolean();
    private final Channel nettyChannel;
    private final AtomicReference<MultipleFutureListener> unflushedWritesListener;
    private final MetricEventsSubject eventsSubject;
    private final ChannelMetricEventProvider metricEventProvider;

    protected DefaultChannelWriter(Channel nettyChannel, MetricEventsSubject<?> eventsSubject, ChannelMetricEventProvider metricEventProvider) {
        this.eventsSubject = eventsSubject;
        this.metricEventProvider = metricEventProvider;
        if (null == nettyChannel) {
            throw new NullPointerException("Channel can not be null.");
        }
        this.nettyChannel = nettyChannel;
        this.unflushedWritesListener = new AtomicReference<MultipleFutureListener>(new MultipleFutureListener(nettyChannel.newPromise()));
    }

    @Override
    public Observable<Void> writeAndFlush(O msg) {
        this.write(msg);
        return this.flush();
    }

    @Override
    public <R> Observable<Void> writeAndFlush(R msg, ContentTransformer<R> transformer) {
        this.write(msg, transformer);
        return this.flush();
    }

    @Override
    public Observable<Void> writeBytesAndFlush(ByteBuf msg) {
        this.writeBytes(msg);
        return this.flush();
    }

    @Override
    public void write(O msg) {
        this.writeOnChannel(msg);
    }

    @Override
    public <R> void write(R msg, ContentTransformer<R> transformer) {
        ByteBuf contentBytes = (ByteBuf)transformer.call(msg, this.getAllocator());
        this.writeOnChannel(contentBytes);
    }

    @Override
    public void writeBytes(ByteBuf msg) {
        this.write(msg, IdentityTransformer.DEFAULT_INSTANCE);
    }

    @Override
    public void writeBytes(byte[] msg) {
        this.write(msg, ByteTransformer.DEFAULT_INSTANCE);
    }

    @Override
    public void writeString(String msg) {
        this.write(msg, new StringTransformer());
    }

    @Override
    public Observable<Void> writeBytesAndFlush(byte[] msg) {
        this.write(msg, ByteTransformer.DEFAULT_INSTANCE);
        return this.flush();
    }

    @Override
    public Observable<Void> writeStringAndFlush(String msg) {
        this.write(msg, new StringTransformer());
        return this.flush();
    }

    @Override
    public void writeFileRegion(FileRegion region) {
        this.writeOnChannel(region);
    }

    @Override
    public Observable<Void> flush() {
        final long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(this.metricEventProvider.getFlushStartEvent());
        MultipleFutureListener existingListener = this.unflushedWritesListener.getAndSet(new MultipleFutureListener(this.nettyChannel.newPromise()));
        this.nettyChannel.flush();
        return existingListener.asObservable().doOnCompleted(new Action0(){

            public void call() {
                DefaultChannelWriter.this.eventsSubject.onEvent(DefaultChannelWriter.this.metricEventProvider.getFlushSuccessEvent(), Clock.onEndMillis(startTimeMillis));
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                DefaultChannelWriter.this.eventsSubject.onEvent(DefaultChannelWriter.this.metricEventProvider.getFlushFailedEvent(), Clock.onEndMillis(startTimeMillis), throwable);
            }
        });
    }

    @Override
    public void cancelPendingWrites(boolean mayInterruptIfRunning) {
        this.unflushedWritesListener.get().cancelPendingFutures(mayInterruptIfRunning);
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this.nettyChannel.alloc();
    }

    protected ChannelFuture writeOnChannel(Object msg) {
        ChannelFuture writeFuture = this.getChannel().write(msg);
        this.unflushedWritesListener.get().listen(writeFuture);
        return writeFuture;
    }

    public Channel getChannel() {
        return this.nettyChannel;
    }

    public boolean isCloseIssued() {
        return this.closeIssued.get();
    }

    @Override
    public Observable<Void> close() {
        return this.close(false);
    }

    @Override
    public Observable<Void> close(boolean flush) {
        if (this.closeIssued.compareAndSet(false, true)) {
            return this._close(flush);
        }
        return CONNECTION_ALREADY_CLOSED;
    }

    protected Observable<Void> _close(boolean flush) {
        return Observable.empty();
    }
}

