/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.client;

import iep.io.reactivex.netty.channel.ObservableConnection;
import iep.io.reactivex.netty.client.ClientChannelFactory;
import iep.io.reactivex.netty.client.ClientConnectionFactory;
import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.client.ConnectionPool;
import iep.io.reactivex.netty.client.ConnectionPoolBuilder;
import iep.io.reactivex.netty.client.RxClient;
import iep.io.reactivex.netty.metrics.MetricEventsListener;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.pipeline.PipelineConfigurators;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

public class RxClientImpl<I, O>
implements RxClient<I, O> {
    protected final String name;
    protected final RxClient.ServerInfo serverInfo;
    protected final Bootstrap clientBootstrap;
    protected final PipelineConfigurator<O, I> pipelineConfigurator;
    protected final ClientChannelFactory<O, I> channelFactory;
    protected final ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory;
    protected final RxClient.ClientConfig clientConfig;
    protected final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    protected final ConnectionPool<O, I> pool;
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public RxClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<O, I> channelFactory, ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        if (null == name) {
            throw new NullPointerException("Name can not be null.");
        }
        if (null == clientBootstrap) {
            throw new NullPointerException("Client bootstrap can not be null.");
        }
        if (null == serverInfo) {
            throw new NullPointerException("Server info can not be null.");
        }
        if (null == clientConfig) {
            throw new NullPointerException("Client config can not be null.");
        }
        if (null == connectionFactory) {
            throw new NullPointerException("Connection factory can not be null.");
        }
        if (null == channelFactory) {
            throw new NullPointerException("Channel factory can not be null.");
        }
        this.name = name;
        this.pool = null;
        this.eventsSubject = eventsSubject;
        this.clientConfig = clientConfig;
        this.serverInfo = serverInfo;
        this.clientBootstrap = clientBootstrap;
        this.connectionFactory = connectionFactory;
        this.connectionFactory.useMetricEventsSubject(eventsSubject);
        this.channelFactory = channelFactory;
        this.channelFactory.useMetricEventsSubject(eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        final PipelineConfigurator<O, I> configurator = this.adaptPipelineConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
        this.clientBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                configurator.configureNewPipeline(ch.pipeline());
            }
        });
    }

    public RxClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<O, I> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        if (null == name) {
            throw new NullPointerException("Name can not be null.");
        }
        if (null == clientBootstrap) {
            throw new NullPointerException("Client bootstrap can not be null.");
        }
        if (null == serverInfo) {
            throw new NullPointerException("Server info can not be null.");
        }
        if (null == clientConfig) {
            throw new NullPointerException("Client config can not be null.");
        }
        if (null == poolBuilder) {
            throw new NullPointerException("Pool builder can not be null.");
        }
        this.name = name;
        this.eventsSubject = eventsSubject;
        this.clientConfig = clientConfig;
        this.serverInfo = serverInfo;
        this.clientBootstrap = clientBootstrap;
        this.pipelineConfigurator = pipelineConfigurator;
        final PipelineConfigurator<O, I> configurator = this.adaptPipelineConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
        this.clientBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                configurator.configureNewPipeline(ch.pipeline());
            }
        });
        this.pool = poolBuilder.build();
        this.channelFactory = poolBuilder.getChannelFactory();
        this.connectionFactory = poolBuilder.getConnectionFactory();
    }

    @Override
    public Observable<ObservableConnection<O, I>> connect() {
        if (this.isShutdown.get()) {
            return Observable.error((Throwable)new IllegalStateException("Client is already shutdown."));
        }
        Observable toReturn = null != this.pool ? this.pool.acquire() : Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ObservableConnection<O, I>>(){

            public void call(Subscriber<? super ObservableConnection<O, I>> subscriber) {
                try {
                    RxClientImpl.this.channelFactory.connect(subscriber, RxClientImpl.this.serverInfo, RxClientImpl.this.connectionFactory);
                }
                catch (Throwable throwable) {
                    subscriber.onError(throwable);
                }
            }
        });
        return toReturn.take(1);
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            return;
        }
        if (null != this.pool) {
            this.pool.shutdown();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    protected PipelineConfigurator<O, I> adaptPipelineConfigurator(PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        return PipelineConfigurators.createClientConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
    }

    @Override
    public Subscription subscribe(MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        return this.eventsSubject.subscribe(listener);
    }
}

