/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.client;

public class HttpRedirectException
extends RuntimeException {
    private static final long serialVersionUID = 612647744832660373L;
    private final Reason reason;

    public HttpRedirectException(Reason reason) {
        this.reason = reason;
    }

    public HttpRedirectException(Reason reason, Throwable cause) {
        super(HttpRedirectException.getMsgWithReason(reason), cause);
        this.reason = reason;
    }

    public HttpRedirectException(Reason reason, String message) {
        super(HttpRedirectException.getMsgWithReason(reason, message));
        this.reason = reason;
    }

    public HttpRedirectException(Reason reason, String message, Throwable cause) {
        super(HttpRedirectException.getMsgWithReason(reason, message), cause);
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    private static String getMsgWithReason(Reason reason) {
        return "Redirect failed. Reason: " + (Object)((Object)reason);
    }

    private static String getMsgWithReason(Reason reason, String message) {
        return HttpRedirectException.getMsgWithReason(reason) + ". Error: " + message;
    }

    public static enum Reason {
        RedirectLoop,
        TooManyRedirects,
        InvalidRedirect;

    }
}

