/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.server;

import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.AbstractHttpConfigurator;
import iep.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import iep.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;

public class HttpServerPipelineConfigurator<I, O>
extends AbstractHttpConfigurator
implements PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> {
    public static final String HTTP_REQUEST_DECODER_HANDLER_NAME = "http-request-decoder";
    public static final String HTTP_RESPONSE_ENCODER_HANDLER_NAME = "http-response-encoder";

    public HttpServerPipelineConfigurator() {
        this(4096, 8192, 8192);
    }

    public HttpServerPipelineConfigurator(int maxInitialLineLength, int maxChunkSize, int maxHeaderSize) {
        super(maxInitialLineLength, maxChunkSize, maxHeaderSize, true);
    }

    public HttpServerPipelineConfigurator(int maxInitialLineLength, int maxChunkSize, int maxHeaderSize, boolean validateHeaders) {
        super(maxInitialLineLength, maxChunkSize, maxHeaderSize, validateHeaders);
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(HTTP_REQUEST_DECODER_HANDLER_NAME, (ChannelHandler)new HttpRequestDecoder(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize, this.validateHeaders));
        pipeline.addLast(HTTP_RESPONSE_ENCODER_HANDLER_NAME, (ChannelHandler)new HttpResponseEncoder());
    }
}

