/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.udp.server;

import iep.io.reactivex.netty.channel.ConnectionHandler;
import iep.io.reactivex.netty.metrics.MetricEventsListener;
import iep.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import iep.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import iep.io.reactivex.netty.protocol.udp.server.UdpServer;
import iep.io.reactivex.netty.server.AbstractServerBuilder;
import iep.io.reactivex.netty.server.ServerMetricsEvent;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;

public class UdpServerBuilder<I, O>
extends AbstractServerBuilder<I, O, Bootstrap, Channel, UdpServerBuilder<I, O>, UdpServer<I, O>> {
    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        this(port, connectionHandler, new Bootstrap());
    }

    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler, Bootstrap bootstrap) {
        super(port, bootstrap, connectionHandler);
    }

    @Override
    protected Class<? extends Channel> defaultServerChannelClass() {
        return NioDatagramChannel.class;
    }

    @Override
    public UdpServerBuilder<I, O> defaultChannelOptions() {
        this.channelOption(ChannelOption.SO_BROADCAST, true);
        return (UdpServerBuilder)super.defaultChannelOptions();
    }

    @Override
    public UdpServerBuilder<I, O> withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        throw new IllegalArgumentException("SSL protocol is not applicable to UDP ");
    }

    @Override
    protected UdpServer<I, O> createServer() {
        if (null != this.pipelineConfigurator) {
            return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.pipelineConfigurator, this.connectionHandler, this.eventExecutorGroup);
        }
        return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.connectionHandler, this.eventExecutorGroup);
    }

    @Override
    protected MetricEventsListener<ServerMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, UdpServer<I, O> server) {
        return factory.forUdpServer(server);
    }
}

