/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.metrics;

import iep.io.reactivex.netty.metrics.ServerMetricEventsListener;
import iep.io.reactivex.netty.protocol.http.server.HttpServerMetricsEvent;
import iep.io.reactivex.netty.server.ServerMetricsEvent;
import java.util.concurrent.TimeUnit;

public abstract class HttpServerMetricEventsListener
extends ServerMetricEventsListener<ServerMetricsEvent<?>> {
    @Override
    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType() instanceof ServerMetricsEvent.EventType) {
            super.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            switch ((HttpServerMetricsEvent.EventType)event.getType()) {
                case NewRequestReceived: {
                    this.onNewRequestReceived();
                    break;
                }
                case RequestHandlingStart: {
                    this.onRequestHandlingStart(duration, timeUnit);
                    break;
                }
                case RequestHeadersReceived: {
                    this.onRequestHeadersReceived();
                    break;
                }
                case RequestContentReceived: {
                    this.onRequestContentReceived();
                    break;
                }
                case RequestReceiveComplete: {
                    this.onRequestReceiveComplete(duration, timeUnit);
                    break;
                }
                case ResponseHeadersWriteStart: {
                    this.onResponseHeadersWriteStart();
                    break;
                }
                case ResponseHeadersWriteSuccess: {
                    this.onResponseHeadersWriteSuccess(duration, timeUnit);
                    break;
                }
                case ResponseHeadersWriteFailed: {
                    this.onResponseHeadersWriteFailed(duration, timeUnit, throwable);
                    break;
                }
                case ResponseContentWriteStart: {
                    this.onResponseContentWriteStart();
                    break;
                }
                case ResponseContentWriteSuccess: {
                    this.onResponseContentWriteSuccess(duration, timeUnit);
                    break;
                }
                case ResponseContentWriteFailed: {
                    this.onResponseContentWriteFailed(duration, timeUnit, throwable);
                    break;
                }
                case RequestHandlingSuccess: {
                    this.onRequestHandlingSuccess(duration, timeUnit);
                    break;
                }
                case RequestHandlingFailed: {
                    this.onRequestHandlingFailed(duration, timeUnit, throwable);
                }
            }
        }
    }

    protected void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onResponseContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onResponseContentWriteSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onResponseContentWriteStart() {
    }

    protected void onResponseHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onResponseHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onResponseHeadersWriteStart() {
    }

    protected void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
    }

    protected void onRequestContentReceived() {
    }

    protected void onRequestHeadersReceived() {
    }

    protected void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
    }

    protected void onNewRequestReceived() {
    }
}

