/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.client;

import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.AbstractHttpConfigurator;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;

public class HttpClientPipelineConfigurator<I, O>
extends AbstractHttpConfigurator
implements PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> {
    public static final String REQUEST_RESPONSE_CONVERTER_HANDLER_NAME = "request-response-converter";
    public static final String HTTP_CODEC_HANDLER_NAME = "http-client-codec";
    public static final boolean FAIL_ON_MISSING_RESPONSE_DEFAULT = true;
    private final boolean failOnMissingResponse;

    public HttpClientPipelineConfigurator() {
        this(4096, 8192, 8192, true, true);
    }

    public HttpClientPipelineConfigurator(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders) {
        this(maxInitialLineLength, maxHeaderSize, maxChunkSize, validateHeaders, true);
    }

    public HttpClientPipelineConfigurator(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this(maxInitialLineLength, maxHeaderSize, maxChunkSize, true, true);
    }

    public HttpClientPipelineConfigurator(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, boolean failOnMissingResponse) {
        super(maxInitialLineLength, maxChunkSize, maxHeaderSize, validateHeaders);
        this.failOnMissingResponse = failOnMissingResponse;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(HTTP_CODEC_HANDLER_NAME, (ChannelHandler)new HttpClientCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize, this.failOnMissingResponse, this.validateHeaders));
    }
}

