/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequestHeaders {
    private final HttpRequest nettyRequest;
    private final HttpHeaders nettyHeaders;

    HttpRequestHeaders(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.nettyHeaders = this.nettyRequest.headers();
    }

    public boolean contains(CharSequence name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii((CharSequence)seq, (ByteBuf)buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase((CharSequence)name1, (CharSequence)name2);
    }

    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength((HttpMessage)this.nettyRequest);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength((HttpMessage)this.nettyRequest, (long)defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate((HttpMessage)this.nettyRequest);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate((HttpMessage)this.nettyRequest, (Date)defaultValue);
    }

    public Date getDateHeader(CharSequence name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public Date getDateHeader(CharSequence name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Date)defaultValue);
    }

    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public Date getDateHeader(String name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)defaultValue);
    }

    public String getHeader(CharSequence name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public String getHeader(CharSequence name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (String)defaultValue);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public String getHeader(String name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (String)name, (String)defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost((HttpMessage)this.nettyRequest);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost((HttpMessage)this.nettyRequest, (String)defaultValue);
    }

    public int getIntHeader(CharSequence name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public int getIntHeader(CharSequence name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (int)defaultValue);
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public int getIntHeader(String name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (String)name, (int)defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected((HttpMessage)this.nettyRequest);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet((HttpMessage)this.nettyRequest);
    }

    public boolean hasContent() {
        if (this.isContentLengthSet()) {
            return this.getContentLength() > 0L;
        }
        return this.isTransferEncodingChunked();
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked((HttpMessage)this.nettyRequest);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }
}

