/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts;

import iep.io.reactivex.netty.contexts.AbstractContextHandler;
import iep.io.reactivex.netty.contexts.ContextAttributeStorageHelper;
import iep.io.reactivex.netty.contexts.ContextKeySupplier;
import iep.io.reactivex.netty.contexts.ContextsContainer;
import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.contexts.RequestIdProvider;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeMap;
import java.util.Map;

public abstract class AbstractClientContextHandler<R, W>
extends AbstractContextHandler<R, W> {
    protected final RequestIdProvider requestIdProvider;
    protected final RequestCorrelator correlator;

    protected AbstractClientContextHandler(RequestCorrelator correlator, RequestIdProvider requestIdProvider) {
        this.correlator = correlator;
        this.requestIdProvider = requestIdProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (this.isAcceptableToRead(msg)) {
                Object response = msg;
                String requestId = this.requestIdProvider.onClientResponse((AttributeMap)ctx);
                if (null != requestId) {
                    this.newRequestIdRead(requestId);
                    ContextsContainer container = ContextAttributeStorageHelper.getContainer(ctx, requestId);
                    if (null != container) {
                        ContextKeySupplier keySupplier = this.newKeySupplierForRead(response);
                        container.consumeBidirectionalContextsFromResponse(keySupplier);
                    }
                }
            }
            super.channelRead(ctx, msg);
        }
        finally {
            String currentRequestId = this.getCurrentlyProcessingRequestId();
            if (null != currentRequestId && this.isLastResponseFragmentToRead(msg)) {
                this.correlator.onClientProcessingEnd(currentRequestId);
            }
        }
    }

    protected abstract void newRequestIdRead(String var1);

    protected abstract String getCurrentlyProcessingRequestId();

    protected abstract boolean isLastResponseFragmentToRead(Object var1);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        String requestId;
        if (this.isAcceptableToWrite(msg) && null != (requestId = this.requestIdProvider.beforeClientRequest((AttributeMap)ctx))) {
            Object request = msg;
            this.addKey(request, this.requestIdProvider.getRequestIdContextKeyName(), requestId);
            ContextsContainer container = this.correlator.getContextForClientRequest(requestId);
            ContextAttributeStorageHelper.setContainer(ctx, requestId, container);
            if (null != container) {
                Map<String, String> serializedContexts = container.getSerializedContexts();
                for (Map.Entry<String, String> entry : serializedContexts.entrySet()) {
                    this.addKey(request, entry.getKey(), entry.getValue());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Added an outbound context key. Name: " + entry.getKey() + ", value: " + entry.getValue());
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof NewContextEvent) {
            NewContextEvent newContextEvent = (NewContextEvent)evt;
            this.correlator.beforeNewClientRequest(newContextEvent.getRequestId(), newContextEvent.getContainer());
        }
        super.userEventTriggered(ctx, evt);
    }

    public static class NewContextEvent {
        private final String requestId;
        private final ContextsContainer container;

        public NewContextEvent(String requestId, ContextsContainer container) {
            this.requestId = requestId;
            this.container = container;
        }

        public ContextsContainer getContainer() {
            return this.container;
        }

        public String getRequestId() {
            return this.requestId;
        }
    }
}

