/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts;

import com.netflix.server.context.ContextSerializationException;
import com.netflix.server.context.ContextSerializer;
import com.netflix.server.context.DirectionAwareContextSerializer;
import iep.io.reactivex.netty.contexts.ContextHolder;
import iep.io.reactivex.netty.contexts.ContextKeySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class ContextSerializationHelper {
    static final String CONTEXT_PROTOCOL_KEY_NAME_PREFIX = "X-Netflix.request.sub.context.";
    static final String ALL_CONTEXTS_NAMES_KEY_NAME = "X-Netflix.request.sub.context.names";
    private static final int CONTEXT_SERIALIZATION_PROPS_SERIALIZATION_FORMAT_VER_INDEX = 0;
    private static final int CONTEXT_SERIALIZATION_PROPS_SERIALIZER_INDEX = 1;
    private static final int CONTEXT_SERIALIZATION_PROPS_VERSION_INDEX = 2;
    private static final int CONTEXT_SERIALIZATION_PROPS_DATA_INDEX = 3;
    private static final int CONTEXT_SERIALIZATION_PROPS_COUNT = 4;
    private static final String CONTEXT_SERIALIZATION_PROPS_SEPARATOR_REGEX = "\\|";
    static final int SERIALIZATION_FORMAT_VER = 1;
    static final String CONTEXT_SERIALIZATION_PROPS_SEPARATOR = "|";
    static final String CONTEXT_HEADER_NAMES_SEPARATOR = ",";
    public static final String EMPTY_SERIALIZED_DATA = "EMPTY";
    private static final Pattern CONTEXT_HEADER_NAMES_SEPARATOR_PATTERN = Pattern.compile(",");
    private static final Pattern CONTEXT_SERIALIZATION_PROPS_SEPARATOR_PATTERN = Pattern.compile("\\|");

    private ContextSerializationHelper() {
    }

    static Map<String, String> getSerializedContexts(Collection<ContextHolder> contextHolders) throws ContextSerializationException {
        return ContextSerializationHelper.getSerializedHeader(contextHolders, false, DirectionAwareContextSerializer.Direction.Outbound);
    }

    static Map<String, String> getSerializedModifiedBidirectionalCtx(Collection<ContextHolder> contextHolders) throws ContextSerializationException {
        return ContextSerializationHelper.getSerializedHeader(contextHolders, true, DirectionAwareContextSerializer.Direction.Inbound);
    }

    static <T> T deserialize(ContextHolder<T> contextHolder, ContextSerializer<T> serializer, DirectionAwareContextSerializer.Direction direction) throws ContextSerializationException {
        DirectionAwareContextSerializer<T> directionAwareContextSerializer;
        T deserialized;
        if (contextHolder.hasContext()) {
            return contextHolder.getContext();
        }
        if (contextHolder.isRaw()) {
            ContextSerializationHelper.unwrapSerializationMetadata(contextHolder);
        }
        if (null == (deserialized = (directionAwareContextSerializer = null == serializer ? contextHolder.getSerializer() : ContextHolder.unifySerializerTypes(serializer)).deserialize(contextHolder.getSerialized(), direction, contextHolder.getSerializedVersion()))) {
            throw new ContextSerializationException("Deserializer for context name: " + contextHolder.getContextName() + " returned null.");
        }
        contextHolder.update(deserialized);
        return deserialized;
    }

    static Map<String, ContextHolder> readContexts(ContextKeySupplier contextKeySupplier) {
        if (null == contextKeySupplier) {
            return Collections.emptyMap();
        }
        return ContextSerializationHelper.readContexts(contextKeySupplier, false);
    }

    static Map<String, ContextHolder> readBidirectionalContexts(ContextKeySupplier keySupplier) {
        if (null == keySupplier) {
            return Collections.emptyMap();
        }
        return ContextSerializationHelper.readContexts(keySupplier, true);
    }

    private static Map<String, ContextHolder> readContexts(ContextKeySupplier keySupplier, boolean bidirectional) {
        String allHeaderNames = keySupplier.getContextValue(ALL_CONTEXTS_NAMES_KEY_NAME);
        if (null == allHeaderNames || allHeaderNames.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] headerNames = CONTEXT_HEADER_NAMES_SEPARATOR_PATTERN.split(allHeaderNames);
        HashMap<String, ContextHolder> toReturn = new HashMap<String, ContextHolder>(headerNames.length);
        for (String headerName : headerNames) {
            String contextName;
            String rawSerializedForm = keySupplier.getContextValue(headerName);
            if (null == rawSerializedForm || null == (contextName = ContextSerializationHelper.getContextNameFromHeaderName(headerName))) continue;
            toReturn.put(contextName, new ContextHolder(contextName, rawSerializedForm, bidirectional));
        }
        return toReturn;
    }

    private static String getContextNameFromHeaderName(String headerName) {
        if (headerName.length() <= CONTEXT_PROTOCOL_KEY_NAME_PREFIX.length()) {
            return null;
        }
        return headerName.substring(CONTEXT_PROTOCOL_KEY_NAME_PREFIX.length());
    }

    private static String constructHeaderName(ContextHolder contextHolder) {
        return CONTEXT_PROTOCOL_KEY_NAME_PREFIX + contextHolder.getContextName();
    }

    private static <T> void unwrapSerializationMetadata(ContextHolder<T> holder) throws ContextSerializationException {
        int version;
        String rawSerializedForm = holder.getRawSerializedForm();
        String[] properties = CONTEXT_SERIALIZATION_PROPS_SEPARATOR_PATTERN.split(rawSerializedForm);
        if (properties.length < 4) {
            throw new ContextSerializationException("Invalid serialized context key format. Number of properties in the serialized form: " + properties.length + " is less than expected: " + 4);
        }
        String data = properties[3];
        if (properties.length > 4) {
            StringBuilder dataBuilder = new StringBuilder();
            for (int i = 3; i < properties.length; ++i) {
                String fragment = properties[i];
                if (dataBuilder.length() > 0) {
                    dataBuilder.append(CONTEXT_SERIALIZATION_PROPS_SEPARATOR);
                }
                dataBuilder.append(fragment);
            }
            data = dataBuilder.toString();
        } else {
            data = ContextSerializationHelper.unmaskIfEmpty(data);
        }
        try {
            version = Integer.parseInt(properties[2]);
        }
        catch (NumberFormatException e) {
            throw new ContextSerializationException("Illegal serialization version: " + properties[2], e);
        }
        holder.update(data, version, properties[1]);
    }

    private static String _serialize(ContextHolder contextHolder, DirectionAwareContextSerializer.Direction direction) throws ContextSerializationException {
        String data;
        if (contextHolder.hasRawSerializedForm()) {
            return contextHolder.getRawSerializedForm();
        }
        DirectionAwareContextSerializer serializer = contextHolder.getSerializer();
        String string = data = contextHolder.hasSerialized() ? contextHolder.getSerialized() : serializer.serialize(contextHolder.getContext(), direction);
        if (null == data) {
            throw new ContextSerializationException("Serializer returned null for context name: " + contextHolder.getContextName());
        }
        if (data.isEmpty()) {
            data = ContextSerializationHelper.maskEmptyString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(1);
        builder.append(CONTEXT_SERIALIZATION_PROPS_SEPARATOR);
        builder.append(contextHolder.getSerializerClassName());
        builder.append(CONTEXT_SERIALIZATION_PROPS_SEPARATOR);
        builder.append(serializer.getVersion());
        builder.append(CONTEXT_SERIALIZATION_PROPS_SEPARATOR);
        builder.append(data);
        return builder.toString();
    }

    private static Map<String, String> getSerializedHeader(Collection<ContextHolder> contextHolders, boolean onlyBidirectionalUpdatedExternally, DirectionAwareContextSerializer.Direction direction) throws ContextSerializationException {
        StringBuilder allContextHeaderNames = new StringBuilder();
        HashMap<String, String> toReturn = new HashMap<String, String>(contextHolders.size());
        for (ContextHolder contextHolder : contextHolders) {
            if (onlyBidirectionalUpdatedExternally && !contextHolder.shouldFlowBackInResponse()) continue;
            String headerName = ContextSerializationHelper.constructHeaderName(contextHolder);
            if (allContextHeaderNames.length() > 0) {
                allContextHeaderNames.append(CONTEXT_HEADER_NAMES_SEPARATOR);
            }
            allContextHeaderNames.append(headerName);
            toReturn.put(headerName, ContextSerializationHelper._serialize(contextHolder, direction));
        }
        if (!toReturn.isEmpty()) {
            toReturn.put(ALL_CONTEXTS_NAMES_KEY_NAME, allContextHeaderNames.toString());
        }
        return Collections.unmodifiableMap(toReturn);
    }

    private static String maskEmptyString() {
        return EMPTY_SERIALIZED_DATA;
    }

    private static String unmaskIfEmpty(String serialized) {
        return EMPTY_SERIALIZED_DATA.equals(serialized) ? "" : serialized;
    }
}

