/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts;

import com.netflix.server.context.ContextSerializationException;
import com.netflix.server.context.ContextSerializer;
import com.netflix.server.context.DirectionAwareContextSerializer;
import com.netflix.server.context.MergeableContext;
import iep.io.reactivex.netty.contexts.ContextHolder;
import iep.io.reactivex.netty.contexts.ContextKeySupplier;
import iep.io.reactivex.netty.contexts.ContextSerializationHelper;
import iep.io.reactivex.netty.contexts.ContextsContainer;
import iep.io.reactivex.netty.contexts.StringSerializer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextsContainerImpl
implements ContextsContainer {
    private static final Logger logger = LoggerFactory.getLogger(ContextsContainerImpl.class);
    private final Map<String, ContextHolder> contexts = new HashMap<String, ContextHolder>();

    public ContextsContainerImpl(ContextKeySupplier keySupplier) {
        this.contexts.putAll(ContextSerializationHelper.readContexts(keySupplier));
    }

    @Override
    public synchronized <T> void addContext(String contextName, T context, ContextSerializer<T> serializer) {
        if (null == contextName || contextName.trim().isEmpty() || null == context || null == serializer) {
            throw new IllegalArgumentException("None of the arguments can be null.");
        }
        ContextHolder<T> newCtxHolder = new ContextHolder<T>(context, contextName, serializer);
        this._addContext(contextName, newCtxHolder);
    }

    @Override
    public synchronized void addContext(String contextName, String context) {
        this.addContext(contextName, context, StringSerializer.INSTANCE);
    }

    @Override
    public synchronized boolean removeContext(String contextName) {
        if (null == contextName || contextName.trim().isEmpty()) {
            throw new IllegalArgumentException("Context name can not be null or empty.");
        }
        return null != this.contexts.remove(contextName);
    }

    @Override
    public synchronized <T> T getContext(String contextName) throws ContextSerializationException {
        return this.getContext(contextName, null);
    }

    @Override
    public synchronized <T> T getContext(String contextName, ContextSerializer<T> serializer) throws ContextSerializationException {
        ContextHolder contextHolder = this.contexts.get(contextName);
        if (null == contextHolder) {
            return null;
        }
        return ContextSerializationHelper.deserialize(contextHolder, serializer, DirectionAwareContextSerializer.Direction.Inbound);
    }

    @Override
    public synchronized Map<String, String> getSerializedContexts() throws ContextSerializationException {
        return ContextSerializationHelper.getSerializedContexts(this.contexts.values());
    }

    @Override
    public synchronized Map<String, String> getModifiedBidirectionalContexts() throws ContextSerializationException {
        return ContextSerializationHelper.getSerializedModifiedBidirectionalCtx(this.contexts.values());
    }

    @Override
    public synchronized void consumeBidirectionalContextsFromResponse(ContextKeySupplier contextKeySupplier) throws ContextSerializationException {
        if (null == contextKeySupplier) {
            return;
        }
        Map<String, ContextHolder> bidirectionalCtx = ContextSerializationHelper.readBidirectionalContexts(contextKeySupplier);
        for (Map.Entry<String, ContextHolder> entry : bidirectionalCtx.entrySet()) {
            ContextHolder value = entry.getValue();
            this._addContext(entry.getKey(), value);
            if (logger.isDebugEnabled()) {
                logger.debug("Found and consumed a modified bi-directional header. Name: " + entry.getKey() + ", value: " + entry.getValue());
            }
            value.markAsUpdatedExternally();
        }
    }

    ContextHolder getContextHolder(String contextName) {
        return this.contexts.get(contextName);
    }

    private <T> void _addContext(String contextName, ContextHolder<T> newCtxHolder) {
        ContextHolder<T> existingCtxHolder = this.contexts.put(contextName, newCtxHolder);
        if (newCtxHolder.isBiDirectional() && null != existingCtxHolder) {
            if (existingCtxHolder.hasRawSerializedForm() && newCtxHolder.hasRawSerializedForm() && existingCtxHolder.getRawSerializedForm().equals(newCtxHolder.getRawSerializedForm())) {
                return;
            }
            try {
                ContextSerializationHelper.deserialize(newCtxHolder, null, DirectionAwareContextSerializer.Direction.Inbound);
                ContextSerializationHelper.deserialize(existingCtxHolder, null, DirectionAwareContextSerializer.Direction.Inbound);
            }
            catch (ContextSerializationException e) {
                logger.error(String.format("Failed to de-serialize new/existing bi-directional context %s. This will overwrite the existing bi-directional context and assume update.", contextName), (Throwable)e);
                newCtxHolder.markAsUpdatedExternally();
                return;
            }
            T newCtx = newCtxHolder.getContext();
            if (existingCtxHolder.getContext().getClass().equals(newCtx.getClass()) && !existingCtxHolder.getContext().equals(newCtx)) {
                if (MergeableContext.class.isAssignableFrom(newCtx.getClass())) {
                    ((MergeableContext)existingCtxHolder.getContext()).merge((MergeableContext)newCtx);
                }
                newCtxHolder.markAsUpdatedExternally();
            }
        }
    }
}

