/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts.http;

import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.contexts.RequestIdProvider;
import iep.io.reactivex.netty.contexts.http.HttpClientContextHandler;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;

public class HttpClientContextConfigurator<I, O>
implements PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> {
    public static final String CTX_HANDLER_NAME = "http-client-context-handler";
    private final RequestCorrelator correlator;
    private final RequestIdProvider requestIdProvider;
    private final PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpConfigurator;

    public HttpClientContextConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpConfigurator) {
        this.requestIdProvider = requestIdProvider;
        this.correlator = correlator;
        this.httpConfigurator = httpConfigurator;
    }

    public void configureNewPipeline(ChannelPipeline pipeline) {
        this.httpConfigurator.configureNewPipeline(pipeline);
        pipeline.addLast(CTX_HANDLER_NAME, (ChannelHandler)new HttpClientContextHandler(this.requestIdProvider, this.correlator));
    }
}

