/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts.http;

import iep.io.reactivex.netty.contexts.AbstractClientContextHandler;
import iep.io.reactivex.netty.contexts.ContextKeySupplier;
import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.contexts.RequestIdProvider;
import iep.io.reactivex.netty.contexts.http.HttpContextKeySupplier;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;

public class HttpClientContextHandler
extends AbstractClientContextHandler<HttpResponse, HttpRequest> {
    private String currentlyProcessingRequestId;

    public HttpClientContextHandler(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        super(correlator, requestIdProvider);
        if (null == requestIdProvider) {
            throw new IllegalArgumentException("Request Id Provider can not be null.");
        }
        if (null == correlator) {
            throw new IllegalArgumentException("Client context provider can not be null.");
        }
    }

    @Override
    protected boolean isAcceptableToRead(Object msg) {
        return msg instanceof HttpResponse;
    }

    @Override
    protected boolean isAcceptableToWrite(Object msg) {
        return msg instanceof HttpRequest;
    }

    @Override
    protected void addKey(HttpRequest msg, String key, String value) {
        msg.headers().add(key, (Object)value);
    }

    @Override
    protected ContextKeySupplier newKeySupplierForWrite(HttpRequest msg) {
        return new HttpContextKeySupplier(msg.headers());
    }

    @Override
    protected ContextKeySupplier newKeySupplierForRead(HttpResponse msg) {
        return new HttpContextKeySupplier(msg.headers());
    }

    @Override
    protected void newRequestIdRead(String requestId) {
        this.currentlyProcessingRequestId = requestId;
    }

    @Override
    protected String getCurrentlyProcessingRequestId() {
        return this.currentlyProcessingRequestId;
    }

    @Override
    protected boolean isLastResponseFragmentToRead(Object response) {
        return response instanceof LastHttpContent;
    }
}

