/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts.http;

import iep.io.reactivex.netty.channel.ObservableConnection;
import iep.io.reactivex.netty.client.ClientChannelFactoryImpl;
import iep.io.reactivex.netty.client.ClientConnectionFactory;
import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.client.RxClient;
import iep.io.reactivex.netty.contexts.AbstractClientContextHandler;
import iep.io.reactivex.netty.contexts.ContextsContainer;
import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import rx.Subscriber;

public class HttpContextClientChannelFactory<I, O>
extends ClientChannelFactoryImpl<HttpClientResponse<O>, HttpClientRequest<I>> {
    private final RequestCorrelator correlator;

    public HttpContextClientChannelFactory(Bootstrap clientBootstrap, RequestCorrelator correlator, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(clientBootstrap, eventsSubject);
        this.correlator = correlator;
    }

    public ChannelFuture connect(Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> subscriber, RxClient.ServerInfo serverInfo, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory) {
        ContextCapturingSubscriber capturingSubscriber = new ContextCapturingSubscriber(subscriber);
        return super.connect((Subscriber)capturingSubscriber, serverInfo, connectionFactory);
    }

    public void onNewConnection(ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>> newConnection, Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> subscriber) {
        ContextCapturingSubscriber subToUse = ContextCapturingSubscriber.class == ((Object)((Object)subscriber)).getClass() ? subscriber : new ContextCapturingSubscriber(subscriber);
        super.onNewConnection(newConnection, subToUse);
    }

    private class ContextCapturingSubscriber
    extends Subscriber<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> {
        private final Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> original;
        private final String requestId;
        private final ContextsContainer container;

        private ContextCapturingSubscriber(Subscriber<? super ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> original) {
            super(original);
            this.original = original;
            this.requestId = HttpContextClientChannelFactory.this.correlator.getRequestIdForClientRequest();
            this.container = HttpContextClientChannelFactory.this.correlator.getContextForClientRequest(this.requestId);
        }

        public void onCompleted() {
            this.original.onCompleted();
        }

        public void onError(Throwable e) {
            this.original.onError(e);
        }

        public void onNext(ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>> connection) {
            if (null != this.requestId && null != this.container) {
                connection.getChannel().pipeline().fireUserEventTriggered((Object)new AbstractClientContextHandler.NewContextEvent(this.requestId, this.container));
            }
            this.original.onNext(connection);
        }
    }
}

