/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts.http;

import iep.io.reactivex.netty.contexts.ContextKeySupplier;
import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.contexts.RequestIdGenerator;
import iep.io.reactivex.netty.contexts.RequestIdProvider;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HttpRequestIdProvider
implements RequestIdProvider {
    public static final AttributeKey<ConcurrentLinkedQueue<String>> REQUEST_IDS_KEY = AttributeKey.valueOf((String)"rxnetty_http_request_ids_queue");
    private final RequestIdGenerator requestIdGenerator;
    private final RequestCorrelator requestCorrelator;
    private final String requestIdHeaderName;

    public HttpRequestIdProvider(RequestIdGenerator requestIdGenerator, RequestCorrelator requestCorrelator, String requestIdHeaderName) {
        this.requestIdGenerator = requestIdGenerator;
        this.requestCorrelator = requestCorrelator;
        this.requestIdHeaderName = requestIdHeaderName;
    }

    public HttpRequestIdProvider(String requestIdHeaderName, RequestCorrelator requestCorrelator) {
        this(new RequestIdGenerator(){

            @Override
            public String newRequestId(ContextKeySupplier keySupplier, AttributeMap channelAttributeMap) {
                return UUID.randomUUID().toString();
            }
        }, requestCorrelator, requestIdHeaderName);
    }

    @Override
    public String newRequestId(ContextKeySupplier keySupplier, AttributeMap channelAttributeMap) {
        String requestId = this.requestIdGenerator.newRequestId(keySupplier, channelAttributeMap);
        HttpRequestIdProvider.addRequestId(channelAttributeMap, requestId);
        return requestId;
    }

    @Override
    public String onServerRequest(ContextKeySupplier keySupplier, AttributeMap channelAttributeMap) {
        String requestId = keySupplier.getContextValue(this.requestIdHeaderName);
        if (null != requestId) {
            HttpRequestIdProvider.addRequestId(channelAttributeMap, requestId);
        }
        return requestId;
    }

    @Override
    public String beforeServerResponse(ContextKeySupplier responseKeySupplier, AttributeMap channelAttributeMap) {
        return HttpRequestIdProvider.getRequestIdFromQueue(channelAttributeMap);
    }

    @Override
    public String beforeClientRequest(AttributeMap clientAttributeMap) {
        String requestId = this.requestCorrelator.getRequestIdForClientRequest();
        if (null != requestId) {
            HttpRequestIdProvider.addRequestId(clientAttributeMap, requestId);
        }
        return requestId;
    }

    @Override
    public String onClientResponse(AttributeMap clientAttributeMap) {
        return HttpRequestIdProvider.getRequestIdFromQueue(clientAttributeMap);
    }

    @Override
    public String getRequestIdContextKeyName() {
        return this.requestIdHeaderName;
    }

    private static void addRequestId(AttributeMap channelAttributeMap, String requestId) {
        ConcurrentLinkedQueue requestIdsQueue = (ConcurrentLinkedQueue)channelAttributeMap.attr(REQUEST_IDS_KEY).get();
        if (null == requestIdsQueue) {
            requestIdsQueue = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue existingQueue = (ConcurrentLinkedQueue)channelAttributeMap.attr(REQUEST_IDS_KEY).setIfAbsent(requestIdsQueue);
            if (null != existingQueue) {
                requestIdsQueue = existingQueue;
            }
        }
        if (null != requestIdsQueue) {
            requestIdsQueue.offer(requestId);
        }
    }

    private static String getRequestIdFromQueue(AttributeMap channelAttributeMap) {
        ConcurrentLinkedQueue requestIdsQueue = (ConcurrentLinkedQueue)channelAttributeMap.attr(REQUEST_IDS_KEY).get();
        if (null != requestIdsQueue) {
            return (String)requestIdsQueue.poll();
        }
        return null;
    }
}

