/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.contexts.http;

import iep.io.reactivex.netty.contexts.RequestCorrelator;
import iep.io.reactivex.netty.contexts.RequestIdProvider;
import iep.io.reactivex.netty.contexts.http.HttpServerContextHandler;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import iep.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;

public class HttpServerContextConfigurator<I, O>
implements PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> {
    public static final String CTX_HANDLER_NAME = "http-server-context-handler";
    private final RequestCorrelator correlator;
    private final RequestIdProvider requestIdProvider;
    private final PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpConfigurator;

    public HttpServerContextConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpConfigurator) {
        this.requestIdProvider = requestIdProvider;
        this.correlator = correlator;
        this.httpConfigurator = httpConfigurator;
    }

    public void configureNewPipeline(ChannelPipeline pipeline) {
        this.httpConfigurator.configureNewPipeline(pipeline);
        pipeline.addLast(CTX_HANDLER_NAME, (ChannelHandler)new HttpServerContextHandler(this.requestIdProvider, this.correlator));
    }
}

