/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.aws.DataPart;
import com.netflix.priam.aws.S3EncryptedFileSystemMBean;
import com.netflix.priam.aws.S3FileSystemBase;
import com.netflix.priam.aws.S3PartUploader;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreException;
import com.netflix.priam.backup.RangeReadInputStream;
import com.netflix.priam.compress.ICompression;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredential;
import com.netflix.priam.cryptography.IFileCryptography;
import com.netflix.priam.merics.BackupMetrics;
import com.netflix.priam.notification.BackupNotificationMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3EncryptedFileSystem
extends S3FileSystemBase
implements S3EncryptedFileSystemMBean {
    private static final Logger logger = LoggerFactory.getLogger(S3EncryptedFileSystem.class);
    private AtomicInteger uploadCount = new AtomicInteger();
    private IFileCryptography encryptor;

    @Inject
    public S3EncryptedFileSystem(Provider<AbstractBackupPath> pathProvider, ICompression compress, IConfiguration config, ICredential cred, @Named(value="filecryptoalgorithm") IFileCryptography fileCryptography, BackupMetrics backupMetrics, BackupNotificationMgr backupNotificationMgr) {
        super(pathProvider, compress, config, backupMetrics, backupNotificationMgr);
        this.encryptor = fileCryptography;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String mbeanName = "com.priam.aws.S3EncryptedFileSystemMBean:name=S3EncryptedFileSystemMBean";
        try {
            mbs.registerMBean(this, new ObjectName(mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to regiser JMX bean: " + mbeanName + " to JMX server.  Msg: " + e.getLocalizedMessage(), e);
        }
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(cred.getAwsCredentialProvider())).withRegion(config.getDC())).build();
    }

    @Override
    public long bytesUploaded() {
        return this.bytesUploaded.get();
    }

    @Override
    public long bytesDownloaded() {
        return this.bytesDownloaded.get();
    }

    @Override
    public void downloadFile(AbstractBackupPath path, OutputStream os) throws BackupRestoreException {
        try {
            RangeReadInputStream rris = new RangeReadInputStream(this.s3Client, this.getPrefix(this.config), path);
            try {
                IOUtils.copyLarge((InputStream)rris, (OutputStream)os);
            }
            catch (Exception ex) {
                throw new BackupRestoreException("Exception encountered when copying bytes from input to output during download", ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)rris);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        catch (Exception e) {
            throw new BackupRestoreException("Exception encountered downloading " + path.getRemotePath() + " from S3 bucket " + this.getPrefix(this.config) + ", Msg: " + e.getMessage(), e);
        }
    }

    @Override
    public void uploadFile(AbstractBackupPath path, InputStream in, long chunkSize) throws BackupRestoreException {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.config.getBackupPrefix(), path.getRemotePath());
        InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
        DataPart part = new DataPart(this.config.getBackupPrefix(), path.getRemotePath(), initResponse.getUploadId());
        ArrayList partETags = Lists.newArrayList();
        String compressedFileName = path.newRestoreFile() + ".compressed";
        logger.debug("Compressing {} with chunk size {}", (Object)compressedFileName, (Object)chunkSize);
        File compressedDstFile = null;
        FileOutputStream compressedDstFileOs = null;
        BufferedOutputStream compressedBos = null;
        try {
            compressedDstFile = new File(compressedFileName);
            compressedDstFileOs = new FileOutputStream(compressedDstFile);
            compressedBos = new BufferedOutputStream(compressedDstFileOs);
        }
        catch (FileNotFoundException e) {
            throw new BackupRestoreException("Not able to find temporary compressed file: " + compressedFileName);
        }
        try {
            Iterator<byte[]> compressedChunks = this.compress.compress(in, chunkSize);
            while (compressedChunks.hasNext()) {
                byte[] compressedChunk = compressedChunks.next();
                compressedBos.write(compressedChunk);
            }
        }
        catch (IOException e) {
            String message = String.format("Exception in compressing the input data during upload to EncryptedStore  Msg: " + e.getMessage(), new Object[0]);
            logger.error(message, (Throwable)e);
            throw new BackupRestoreException(message);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)compressedBos);
        }
        FileInputStream compressedFileIs = null;
        BufferedInputStream compressedBis = null;
        try {
            compressedFileIs = new FileInputStream(new File(compressedFileName));
            compressedBis = new BufferedInputStream(compressedFileIs);
            Iterator<byte[]> chunks = this.encryptor.encryptStream(compressedBis, path.getRemotePath());
            int partNum = 0;
            while (chunks.hasNext()) {
                byte[] chunk = chunks.next();
                this.rateLimiter.acquire(chunk.length);
                DataPart dp = new DataPart(++partNum, chunk, this.config.getBackupPrefix(), path.getRemotePath(), initResponse.getUploadId());
                S3PartUploader partUploader = new S3PartUploader(this.s3Client, dp, partETags);
                this.executor.submit(partUploader);
                this.bytesUploaded.addAndGet(chunk.length);
            }
            this.executor.sleepTillEmpty();
            if (partNum != partETags.size()) {
                throw new BackupRestoreException("Number of parts(" + partNum + ")  does not match the expected number of uploaded parts(" + partETags.size() + ")");
            }
            CompleteMultipartUploadResult resultS3MultiPartUploadComplete = new S3PartUploader(this.s3Client, part, partETags).completeUpload();
            this.checkSuccessfulUpload(resultS3MultiPartUploadComplete, path);
        }
        catch (Exception e) {
            try {
                throw this.encounterError(path, new S3PartUploader(this.s3Client, part, partETags), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressedBis);
                if (compressedDstFile.exists()) {
                    compressedDstFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)compressedBis);
        if (compressedDstFile.exists()) {
            compressedDstFile.delete();
        }
    }

    @Override
    public int getActivecount() {
        return this.executor.getActiveCount();
    }
}

