/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.priam.aws.S3BackupPath;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.config.IConfiguration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PrefixIterator
implements Iterator<AbstractBackupPath> {
    private static final Logger logger = LoggerFactory.getLogger(S3PrefixIterator.class);
    private final IConfiguration config;
    private final AmazonS3 s3Client;
    private final Provider<AbstractBackupPath> pathProvider;
    private Iterator<AbstractBackupPath> iterator;
    private String bucket = "";
    private String clusterPath = "";
    private SimpleDateFormat datefmt = new SimpleDateFormat("yyyyMMdd");
    private ObjectListing objectListing = null;
    Date date;

    @Inject
    public S3PrefixIterator(IConfiguration config, Provider<AbstractBackupPath> pathProvider, AmazonS3 s3Client, Date date) {
        this.config = config;
        this.pathProvider = pathProvider;
        this.s3Client = s3Client;
        this.date = date;
        String path = "";
        path = StringUtils.isNotBlank((CharSequence)config.getRestorePrefix()) ? config.getRestorePrefix() : config.getBackupPrefix();
        String[] paths = path.split(String.valueOf(S3BackupPath.PATH_SEP));
        this.bucket = paths[0];
        this.clusterPath = this.remotePrefix(path);
        this.iterator = this.createIterator();
    }

    private void initListing() {
        ListObjectsRequest listReq = new ListObjectsRequest();
        listReq.setBucketName(this.bucket);
        listReq.setPrefix(this.clusterPath);
        listReq.setDelimiter(String.valueOf(AbstractBackupPath.PATH_SEP));
        logger.info("Using cluster prefix for searching tokens: {}", (Object)this.clusterPath);
        this.objectListing = this.s3Client.listObjects(listReq);
    }

    private Iterator<AbstractBackupPath> createIterator() {
        if (this.objectListing == null) {
            this.initListing();
        }
        ArrayList temp = Lists.newArrayList();
        for (String summary : this.objectListing.getCommonPrefixes()) {
            if (!this.pathExistsForDate(summary, this.datefmt.format(this.date))) continue;
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            path.parsePartialPrefix(summary);
            temp.add(path);
        }
        return temp.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        while (this.objectListing.isTruncated() && !this.iterator.hasNext()) {
            this.objectListing = this.s3Client.listNextBatchOfObjects(this.objectListing);
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public AbstractBackupPath next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
    }

    private String remotePrefix(String location) {
        StringBuffer buff = new StringBuffer();
        String[] elements = location.split(String.valueOf(S3BackupPath.PATH_SEP));
        if (elements.length <= 1) {
            buff.append(this.config.getBackupLocation()).append(S3BackupPath.PATH_SEP);
            buff.append(this.config.getDC()).append(S3BackupPath.PATH_SEP);
            buff.append(this.config.getAppName()).append(S3BackupPath.PATH_SEP);
        } else {
            assert (elements.length >= 4) : "Too few elements in path " + location;
            buff.append(elements[1]).append(S3BackupPath.PATH_SEP);
            buff.append(elements[2]).append(S3BackupPath.PATH_SEP);
            buff.append(elements[3]).append(S3BackupPath.PATH_SEP);
        }
        return buff.toString();
    }

    private boolean pathExistsForDate(String tprefix, String datestr) {
        ListObjectsRequest listReq = new ListObjectsRequest();
        listReq.setBucketName(this.bucket);
        listReq.setPrefix(tprefix + datestr);
        ObjectListing listing = this.s3Client.listObjects(listReq);
        return listing.getObjectSummaries().size() > 0;
    }
}

