/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredential;
import com.netflix.priam.identity.PriamInstance;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Singleton
public class SDBInstanceData {
    public static final String DOMAIN = "InstanceIdentity";
    public static final String ALL_QUERY = "select * from InstanceIdentity where appId='%s'";
    public static final String INSTANCE_QUERY = "select * from InstanceIdentity where appId='%s' and location='%s' and id='%d'";
    private final ICredential provider;
    private final IConfiguration configuration;

    @Inject
    public SDBInstanceData(ICredential provider, IConfiguration configuration) {
        this.provider = provider;
        this.configuration = configuration;
    }

    public PriamInstance getInstance(String app, String dc, int id) {
        AmazonSimpleDB simpleDBClient = this.getSimpleDBClient();
        SelectRequest request = new SelectRequest(String.format(INSTANCE_QUERY, app, dc, id));
        SelectResult result = simpleDBClient.select(request);
        if (result.getItems().size() == 0) {
            return null;
        }
        return this.transform((Item)result.getItems().get(0));
    }

    public Set<PriamInstance> getAllIds(String app) {
        AmazonSimpleDB simpleDBClient = this.getSimpleDBClient();
        HashSet<PriamInstance> inslist = new HashSet<PriamInstance>();
        String nextToken = null;
        do {
            SelectRequest request = new SelectRequest(String.format(ALL_QUERY, app));
            request.setNextToken(nextToken);
            SelectResult result = simpleDBClient.select(request);
            nextToken = result.getNextToken();
            Iterator itemiter = result.getItems().iterator();
            while (itemiter.hasNext()) {
                inslist.add(this.transform((Item)itemiter.next()));
            }
        } while (nextToken != null);
        return inslist;
    }

    public void createInstance(PriamInstance instance) throws AmazonServiceException {
        AmazonSimpleDB simpleDBClient = this.getSimpleDBClient();
        PutAttributesRequest putReq = new PutAttributesRequest(DOMAIN, this.getKey(instance), this.createAttributesToRegister(instance));
        simpleDBClient.putAttributes(putReq);
    }

    public void registerInstance(PriamInstance instance) throws AmazonServiceException {
        AmazonSimpleDB simpleDBClient = this.getSimpleDBClient();
        PutAttributesRequest putReq = new PutAttributesRequest(DOMAIN, this.getKey(instance), this.createAttributesToRegister(instance));
        UpdateCondition expected = new UpdateCondition();
        expected.setName("instanceId");
        expected.setExists(Boolean.valueOf(false));
        putReq.setExpected(expected);
        simpleDBClient.putAttributes(putReq);
    }

    public void deregisterInstance(PriamInstance instance) throws AmazonServiceException {
        AmazonSimpleDB simpleDBClient = this.getSimpleDBClient();
        DeleteAttributesRequest delReq = new DeleteAttributesRequest(DOMAIN, this.getKey(instance), this.createAttributesToDeRegister(instance));
        simpleDBClient.deleteAttributes(delReq);
    }

    protected List<ReplaceableAttribute> createAttributesToRegister(PriamInstance instance) {
        instance.setUpdatetime(new Date().getTime());
        ArrayList<ReplaceableAttribute> attrs = new ArrayList<ReplaceableAttribute>();
        attrs.add(new ReplaceableAttribute("instanceId", instance.getInstanceId(), Boolean.valueOf(false)));
        attrs.add(new ReplaceableAttribute("token", instance.getToken(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("appId", instance.getApp(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("id", Integer.toString(instance.getId()), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("availabilityZone", instance.getRac(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("elasticIP", instance.getHostIP(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("hostname", instance.getHostName(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("location", instance.getDC(), Boolean.valueOf(true)));
        attrs.add(new ReplaceableAttribute("updateTimestamp", Long.toString(instance.getUpdatetime()), Boolean.valueOf(true)));
        return attrs;
    }

    protected List<Attribute> createAttributesToDeRegister(PriamInstance instance) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("instanceId", instance.getInstanceId()));
        attrs.add(new Attribute("token", instance.getToken()));
        attrs.add(new Attribute("appId", instance.getApp()));
        attrs.add(new Attribute("id", Integer.toString(instance.getId())));
        attrs.add(new Attribute("availabilityZone", instance.getRac()));
        attrs.add(new Attribute("elasticIP", instance.getHostIP()));
        attrs.add(new Attribute("hostname", instance.getHostName()));
        attrs.add(new Attribute("location", instance.getDC()));
        attrs.add(new Attribute("updateTimestamp", Long.toString(instance.getUpdatetime())));
        return attrs;
    }

    public PriamInstance transform(Item item) {
        PriamInstance ins = new PriamInstance();
        for (Attribute att : item.getAttributes()) {
            if (att.getName().equals("instanceId")) {
                ins.setInstanceId(att.getValue());
                continue;
            }
            if (att.getName().equals("token")) {
                ins.setToken(att.getValue());
                continue;
            }
            if (att.getName().equals("appId")) {
                ins.setApp(att.getValue());
                continue;
            }
            if (att.getName().equals("id")) {
                ins.setId(Integer.parseInt(att.getValue()));
                continue;
            }
            if (att.getName().equals("availabilityZone")) {
                ins.setRac(att.getValue());
                continue;
            }
            if (att.getName().equals("elasticIP")) {
                ins.setHostIP(att.getValue());
                continue;
            }
            if (att.getName().equals("hostname")) {
                ins.setHost(att.getValue());
                continue;
            }
            if (att.getName().equals("location")) {
                ins.setDC(att.getValue());
                continue;
            }
            if (!att.getName().equals("updateTimestamp")) continue;
            ins.setUpdatetime(Long.parseLong(att.getValue()));
        }
        return ins;
    }

    private String getKey(PriamInstance instance) {
        return instance.getApp() + "_" + instance.getDC() + "_" + instance.getId();
    }

    private AmazonSimpleDB getSimpleDBClient() {
        return (AmazonSimpleDB)((AmazonSimpleDBClientBuilder)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClient.builder().withCredentials(this.provider.getAwsCredentialProvider())).withRegion(this.configuration.getSDBInstanceIdentityRegion())).build();
    }

    public static class Attributes {
        public static final String APP_ID = "appId";
        public static final String ID = "id";
        public static final String INSTANCE_ID = "instanceId";
        public static final String TOKEN = "token";
        public static final String AVAILABILITY_ZONE = "availabilityZone";
        public static final String ELASTIC_IP = "elasticIP";
        public static final String UPDATE_TS = "updateTimestamp";
        public static final String LOCATION = "location";
        public static final String HOSTNAME = "hostname";
    }
}

