/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.RetryableCallable;

@Singleton
public class UpdateCleanupPolicy
extends Task {
    public static final String JOBNAME = "UpdateCleanupPolicy";
    private IBackupFileSystem fs;

    @Inject
    public UpdateCleanupPolicy(IConfiguration config, @Named(value="backup") IBackupFileSystem fs) {
        super(config);
        this.fs = fs;
    }

    @Override
    public void execute() throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                UpdateCleanupPolicy.this.fs.cleanup();
                return null;
            }
        }.call();
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME);
    }
}

