/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.netflix.priam.backup.Status;
import com.netflix.priam.utils.DateUtil;
import com.netflix.priam.utils.GsonJsonSerializer;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackupMetadata
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BackupMetadata.class);
    private String snapshotDate;
    private String token;
    private Date start;
    private Date completed;
    private Status status;
    private String snapshotLocation;

    public BackupMetadata(String token, Date start) throws Exception {
        if (start == null || token == null || StringUtils.isEmpty((CharSequence)token)) {
            throw new Exception(String.format("Invalid Input: Token: {} or start date:{} is null or empty.", token, start));
        }
        this.snapshotDate = DateUtil.formatyyyyMMdd(start);
        this.token = token;
        this.start = start;
        this.status = Status.STARTED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupMetadata that = (BackupMetadata)o;
        if (!this.snapshotDate.equals(that.snapshotDate)) {
            return false;
        }
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.start.equals(that.start);
    }

    public int hashCode() {
        int result = this.snapshotDate.hashCode();
        result = 31 * result + this.token.hashCode();
        result = 31 * result + this.start.hashCode();
        return result;
    }

    public String getSnapshotDate() {
        return this.snapshotDate;
    }

    public String getToken() {
        return this.token;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getCompleted() {
        return this.completed;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setCompleted(Date completed) {
        this.completed = completed;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSnapshotLocation() {
        return this.snapshotLocation;
    }

    public void setSnapshotLocation(String snapshotLocation) {
        this.snapshotLocation = snapshotLocation;
    }

    public String toString() {
        return GsonJsonSerializer.getGson().toJson((Object)this);
    }
}

