/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.config.IConfiguration;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class IncrementalMetaData
extends MetaData {
    private String metaFileName = null;

    @Inject
    public IncrementalMetaData(IConfiguration config, Provider<AbstractBackupPath> pathFactory, IFileSystemContext backupFileSystemCtx) {
        super(pathFactory, backupFileSystemCtx, config);
    }

    public void setMetaFileName(String name) {
        this.metaFileName = name;
    }

    @Override
    public File createTmpMetaFile() throws IOException {
        File metafile = null;
        File destFile = null;
        if (this.metaFileName == null) {
            metafile = File.createTempFile("incrementalMeta", ".json");
            destFile = new File(metafile.getParent(), "incrementalMeta.json");
        } else {
            metafile = File.createTempFile(this.metaFileName, ".json");
            destFile = new File(metafile.getParent(), this.metaFileName + ".json");
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        try {
            FileUtils.moveFile((File)metafile, (File)destFile);
        }
        finally {
            if (metafile != null && metafile.exists()) {
                FileUtils.deleteQuietly((File)metafile);
            }
        }
        return destFile;
    }
}

