/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.netflix.priam.compress.ICompression;
import com.netflix.priam.utils.GsonJsonSerializer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import org.codehaus.jettison.json.JSONObject;

public class FileUploadResult {
    private Path fileName;
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    private String keyspaceName;
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    private String columnFamilyName;
    private Instant lastModifiedTime;
    private Instant fileCreationTime;
    private long fileSizeOnDisk;
    private Boolean isUploaded;
    private ICompression.CompressionAlgorithm compression = ICompression.CompressionAlgorithm.SNAPPY;
    private Path backupPath;

    public FileUploadResult(Path fileName, String keyspaceName, String columnFamilyName, Instant lastModifiedTime, Instant fileCreationTime, long fileSizeOnDisk) {
        this.fileName = fileName;
        this.keyspaceName = keyspaceName;
        this.columnFamilyName = columnFamilyName;
        this.lastModifiedTime = lastModifiedTime;
        this.fileCreationTime = fileCreationTime;
        this.fileSizeOnDisk = fileSizeOnDisk;
    }

    public static FileUploadResult getFileUploadResult(String keyspaceName, String columnFamilyName, Path file) throws Exception {
        BasicFileAttributes fileAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        return new FileUploadResult(file, keyspaceName, columnFamilyName, fileAttributes.lastModifiedTime().toInstant(), fileAttributes.creationTime().toInstant(), fileAttributes.size());
    }

    public static FileUploadResult getFileUploadResult(String keyspaceName, String columnFamilyName, File file) throws Exception {
        return FileUploadResult.getFileUploadResult(keyspaceName, columnFamilyName, file.toPath());
    }

    public Path getFileName() {
        return this.fileName;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Instant getFileCreationTime() {
        return this.fileCreationTime;
    }

    public long getFileSizeOnDisk() {
        return this.fileSizeOnDisk;
    }

    public Boolean getUploaded() {
        return this.isUploaded;
    }

    public void setUploaded(Boolean uploaded) {
        this.isUploaded = uploaded;
    }

    public ICompression.CompressionAlgorithm getCompression() {
        return this.compression;
    }

    public void setCompression(ICompression.CompressionAlgorithm compression) {
        this.compression = compression;
    }

    public Path getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(Path backupPath) {
        this.backupPath = backupPath;
    }

    public JSONObject getJSONObject() throws Exception {
        JSONObject result = new JSONObject();
        result.put("file", (Object)this.fileName.toFile().getName());
        result.put("modify", this.lastModifiedTime.toEpochMilli());
        result.put("creation", this.fileCreationTime.toEpochMilli());
        result.put("size", this.fileSizeOnDisk);
        result.put("compression", (Object)this.compression.name());
        result.put("uploaded", (Object)this.isUploaded);
        result.put("loc", (Object)this.backupPath);
        return result;
    }

    public String toString() {
        return GsonJsonSerializer.getGson().toJson((Object)this);
    }
}

