/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.config;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.configSource.IConfigSource;
import com.netflix.priam.cred.ICredential;
import com.netflix.priam.identity.InstanceEnvIdentity;
import com.netflix.priam.identity.config.InstanceDataRetriever;
import com.netflix.priam.scheduler.SchedulerType;
import com.netflix.priam.scheduler.UnsupportedTypeException;
import com.netflix.priam.tuner.GCType;
import com.netflix.priam.tuner.JVMOption;
import com.netflix.priam.tuner.JVMOptionsTuner;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PriamConfiguration
implements IConfiguration {
    public static final String PRIAM_PRE = "priam";
    private static final String CONFIG_CASS_HOME_DIR = "priam.cass.home";
    private static final String CONFIG_CASS_START_SCRIPT = "priam.cass.startscript";
    private static final String CONFIG_CASS_STOP_SCRIPT = "priam.cass.stopscript";
    private static final String CONFIG_CASS_USE_SUDO = "priam.cass.usesudo";
    private static final String CONFIG_CLUSTER_NAME = "priam.clustername";
    private static final String CONFIG_SEED_PROVIDER_NAME = "priam.seed.provider";
    private static final String CONFIG_LOAD_LOCAL_PROPERTIES = "priam.localbootstrap.enable";
    private static final String CONFIG_MAX_HEAP_SIZE = "priam.heap.size.";
    private static final String CONFIG_DATA_LOCATION = "priam.data.location";
    private static final String CONFIG_LOGS_LOCATION = "priam.logs.location";
    private static final String CONFIG_MR_ENABLE = "priam.multiregion.enable";
    private static final String CONFIG_CL_LOCATION = "priam.commitlog.location";
    private static final String CONFIG_JMX_LISTERN_PORT_NAME = "priam.jmx.port";
    private static final String CONFIG_JMX_USERNAME = "priam.jmx.username";
    private static final String CONFIG_JMX_PASSWORD = "priam.jmx.password";
    private static final String CONFIG_JMX_ENABLE_REMOTE = "priam.jmx.remote.enable";
    private static final String CONFIG_AVAILABILITY_ZONES = "priam.zones.available";
    private static final String CONFIG_SAVE_CACHE_LOCATION = "priam.cache.location";
    private static final String CONFIG_NEW_MAX_HEAP_SIZE = "priam.heap.newgen.size.";
    private static final String CONFIG_DIRECT_MAX_HEAP_SIZE = "priam.direct.memory.size.";
    private static final String CONFIG_NATIVE_PROTOCOL_PORT = "priam.nativeTransport.port";
    private static final String CONFIG_NATIVE_PROTOCOL_ENABLED = "priam.nativeTransport.enabled";
    private static final String CONFIG_STORAGE_LISTERN_PORT_NAME = "priam.storage.port";
    private static final String CONFIG_SSL_STORAGE_LISTERN_PORT_NAME = "priam.ssl.storage.port";
    private static final String CONFIG_CL_BK_LOCATION = "priam.backup.commitlog.location";
    private static final String CONFIG_THROTTLE_UPLOAD_PER_SECOND = "priam.upload.throttle";
    private static final String CONFIG_IN_MEMORY_COMPACTION_LIMIT = "priam.memory.compaction.limit";
    private static final String CONFIG_COMPACTION_THROUHPUT = "priam.compaction.throughput";
    private static final String CONFIG_MAX_HINT_WINDOW_IN_MS = "priam.hint.window";
    private static final String CONFIG_HINT_DELAY = "priam.hint.delay";
    private static final String CONFIG_BOOTCLUSTER_NAME = "priam.bootcluster";
    private static final String CONFIG_ENDPOINT_SNITCH = "priam.endpoint_snitch";
    private static final String CONFIG_MEMTABLE_TOTAL_SPACE = "priam.memtabletotalspace";
    private static final String CONFIG_MEMTABLE_CLEANUP_THRESHOLD = "priam.memtable.cleanup.threshold";
    private static final String CONFIG_CASS_PROCESS_NAME = "priam.cass.process";
    private static final String CONFIG_VNODE_NUM_TOKENS = "priam.vnodes.numTokens";
    private static final String CONFIG_YAML_LOCATION = "priam.yamlLocation";
    private static final String CONFIG_AUTHENTICATOR = "priam.authenticator";
    private static final String CONFIG_AUTHORIZER = "priam.authorizer";
    private static final String CONFIG_TARGET_KEYSPACE_NAME = "priam.target.keyspace";
    private static final String CONFIG_TARGET_COLUMN_FAMILY_NAME = "priam.target.columnfamily";
    private static final String CONFIG_CASS_MANUAL_START_ENABLE = "priam.cass.manual.start.enable";
    private static final String CONFIG_REMEDIATE_DEAD_CASSANDRA_RATE_S = "priam.remediate.dead.cassandra.rate";
    private static final String CONFIG_CREATE_NEW_TOKEN_ENABLE = "priam.create.new.token.enable";
    private static final String CONFIG_BACKUP_THREADS = "priam.backup.threads";
    private static final String CONFIG_RESTORE_PREFIX = "priam.restore.prefix";
    private static final String CONFIG_INCR_BK_ENABLE = "priam.backup.incremental.enable";
    private static final String CONFIG_SNAPSHOT_KEYSPACE_FILTER = "priam.snapshot.keyspace.filter";
    private static final String CONFIG_SNAPSHOT_CF_FILTER = "priam.snapshot.cf.filter";
    private static final String CONFIG_INCREMENTAL_KEYSPACE_FILTER = "priam.incremental.keyspace.filter";
    private static final String CONFIG_INCREMENTAL_CF_FILTER = "priam.incremental.cf.filter";
    private static final String CONFIG_RESTORE_KEYSPACE_FILTER = "priam.restore.keyspace.filter";
    private static final String CONFIG_RESTORE_CF_FILTER = "priam.restore.cf.filter";
    private static final String CONFIG_CL_BK_ENABLE = "priam.backup.commitlog.enable";
    private static final String CONFIG_AUTO_RESTORE_SNAPSHOTNAME = "priam.restore.snapshot";
    private static final String CONFIG_BUCKET_NAME = "priam.s3.bucket";
    private static final String CONFIG_BACKUP_SCHEDULE_TYPE = "priam.backup.schedule.type";
    private static final String CONFIG_BACKUP_HOUR = "priam.backup.hour";
    private static final String CONFIG_BACKUP_CRON_EXPRESSION = "priam.backup.cron";
    private static final String CONFIG_S3_BASE_DIR = "priam.s3.base_dir";
    private static final String CONFIG_RESTORE_THREADS = "priam.restore.threads";
    private static final String CONFIG_RESTORE_CLOSEST_TOKEN = "priam.restore.closesttoken";
    private static final String CONFIG_RESTORE_KEYSPACES = "priam.restore.keyspaces";
    private static final String CONFIG_BACKUP_CHUNK_SIZE = "priam.backup.chunksizemb";
    private static final String CONFIG_BACKUP_RETENTION = "priam.backup.retention";
    private static final String CONFIG_BACKUP_RACS = "priam.backup.racs";
    private static final String CONFIG_BACKUP_STATUS_FILE_LOCATION = "priam.backup.status.location";
    private static final String CONFIG_MULTITHREADED_COMPACTION = "priam.multithreaded.compaction";
    private static final String CONFIG_STREAMING_THROUGHPUT_MB = "priam.streaming.throughput.mb";
    private static final String CONFIG_STREAMING_SOCKET_TIMEOUT_IN_MS = "priam.streaming.socket.timeout.ms";
    private static final String CONFIG_TOMBSTONE_FAILURE_THRESHOLD = "priam.tombstone.failure.threshold";
    private static final String CONFIG_TOMBSTONE_WARNING_THRESHOLD = "priam.tombstone.warning.threshold";
    private static final String CONFIG_PARTITIONER = "priam.partitioner";
    private static final String CONFIG_KEYCACHE_SIZE = "priam.keyCache.size";
    private static final String CONFIG_KEYCACHE_COUNT = "priam.keyCache.count";
    private static final String CONFIG_ROWCACHE_SIZE = "priam.rowCache.size";
    private static final String CONFIG_ROWCACHE_COUNT = "priam.rowCache.count";
    private static final String CONFIG_MAX_HINT_THREADS = "priam.hints.maxThreads";
    private static final String CONFIG_HINTS_THROTTLE_KB = "priam.hints.throttleKb";
    private static final String CONFIG_INTERNODE_COMPRESSION = "priam.internodeCompression";
    private static final String CONFIG_COMMITLOG_BKUP_ENABLED = "priam.clbackup.enabled";
    private static final String CONFIG_COMMITLOG_PROPS_FILE = "priam.clbackup.propsfile";
    private static final String CONFIG_COMMITLOG_ARCHIVE_CMD = "priam.clbackup.archiveCmd";
    private static final String CONFIG_COMMITLOG_RESTORE_CMD = "priam.clbackup.restoreCmd";
    private static final String CONFIG_COMMITLOG_RESTORE_DIRS = "priam.clbackup.restoreDirs";
    private static final String CONFIG_COMMITLOG_RESTORE_POINT_IN_TIME = "priam.clbackup.restoreTime";
    private static final String CONFIG_COMMITLOG_RESTORE_MAX = "priam.clrestore.max";
    private static final String CONFIG_CLIENT_SSL_ENABLED = "priam.client.sslEnabled";
    private static final String CONFIG_INTERNODE_ENCRYPTION = "priam.internodeEncryption";
    private static final String CONFIG_DSNITCH_ENABLED = "priam.dsnitchEnabled";
    private static final String CONFIG_CONCURRENT_READS = "priam.concurrentReads";
    private static final String CONFIG_CONCURRENT_WRITES = "priam.concurrentWrites";
    private static final String CONFIG_CONCURRENT_COMPACTORS = "priam.concurrentCompactors";
    private static final String CONFIG_RPC_SERVER_TYPE = "priam.rpc.server.type";
    private static final String CONFIG_RPC_MIN_THREADS = "priam.rpc.min.threads";
    private static final String CONFIG_RPC_MAX_THREADS = "priam.rpc.max.threads";
    private static final String CONFIG_INDEX_INTERVAL = "priam.index.interval";
    private static final String CONFIG_EXTRA_PARAMS = "priam.extra.params";
    private static final String CONFIG_AUTO_BOOTSTRAP = "priam.auto.bootstrap";
    private static final String CONFIG_DSE_CLUSTER_TYPE = "priam.dse.cluster.type";
    private static final String CONFIG_EXTRA_ENV_PARAMS = "priam.extra.env.params";
    private static final String CONFIG_RESTORE_SOURCE_TYPE = "priam.restore.source.type";
    private static final String CONFIG_ENCRYPTED_BACKUP_ENABLED = "priam.encrypted.backup.enabled";
    private static final String CONFIG_PRIKEY_LOC = "priam.private.key.location";
    private static final String CONFIG_PGP_PASSWORD_PHRASE = "priam.pgp.password.phrase";
    private static final String CONFIG_PGP_PUB_KEY_LOC = "priam.pgp.pubkey.file.location";
    private static final String CONFIG_GCS_SERVICE_ACCT_ID = "priam.gcs.service.acct.id";
    private static final String CONFIG_GCS_SERVICE_ACCT_PRIVATE_KEY_LOC = "priam.gcs.service.acct.private.key";
    private static final String CONFIG_ASG_NAME = "priam.az.asgname";
    private static final String CONFIG_SIBLING_ASG_NAMES = "priam.az.sibling.asgnames";
    private static final String CONFIG_REGION_NAME = "priam.az.region";
    private static final String SDB_INSTANCE_INDENTITY_REGION_NAME = "priam.sdb.instanceIdentity.region";
    private static final String CONFIG_ACL_GROUP_NAME = "priam.acl.groupname";
    private static String ASG_NAME = System.getenv("ASG_NAME");
    private static String REGION = System.getenv("EC2_REGION");
    private static final String CONFIG_VPC_RING = "priam.vpc";
    private static final String CONFIG_S3_ROLE_ASSUMPTION_ARN = "priam.roleassumption.arn";
    private static final String CONFIG_EC2_ROLE_ASSUMPTION_ARN = "priam.ec2.roleassumption.arn";
    private static final String CONFIG_VPC_ROLE_ASSUMPTION_ARN = "priam.vpc.roleassumption.arn";
    private static final String CONFIG_DUAL_ACCOUNT = "priam.roleassumption.dualaccount";
    private static final String CONFIG_POST_RESTORE_HOOK_ENABLED = "priam.postrestorehook.enabled";
    private static final String CONFIG_POST_RESTORE_HOOK = "priam.postrestorehook";
    private static final String CONFIG_POST_RESTORE_HOOK_HEARTBEAT_FILENAME = "priam.postrestorehook.heartbeat.filename";
    private static final String CONFIG_POST_RESTORE_HOOK_DONE_FILENAME = "priam.postrestorehook.done.filename";
    private static final String CONFIG_POST_RESTORE_HOOK_TIMEOUT_IN_DAYS = "priam.postrestorehook.timeout.in.days";
    private static final String CONFIG_POST_RESTORE_HOOK_HEARTBEAT_TIMEOUT_MS = "priam.postrestorehook.heartbeat.timeout";
    private static final String CONFIG_POST_RESTORE_HOOK_HEARTBEAT_CHECK_FREQUENCY_MS = "priam.postrestorehook.heartbeat.check.frequency";
    private String RAC;
    private String NETWORK_VPC;
    private final String DEFAULT_CLUSTER_NAME = "cass_cluster";
    private final String CASS_BASE_DATA_DIR = "/var/lib/cassandra";
    private final String DEFAULT_DATA_LOCATION = "/var/lib/cassandra/data";
    private final String DEFAULT_LOGS_LOCATION = "/var/lib/cassandra/logs";
    private final String DEFAULT_COMMIT_LOG_LOCATION = "/var/lib/cassandra/commitlog";
    private final String DEFAULT_CACHE_LOCATION = "/var/lib/cassandra/saved_caches";
    private final String DEFAULT_HINTS_DIR_LOCATION = "/var/lib/cassandra/hints";
    private final String DEFAULT_ENDPOINT_SNITCH = "org.apache.cassandra.locator.Ec2Snitch";
    private final String DEFAULT_SEED_PROVIDER = "com.netflix.priam.cassandra.extensions.NFSeedProvider";
    private final String DEFAULT_PARTITIONER = "org.apache.cassandra.dht.RandomPartitioner";
    public static final String DEFAULT_AUTHENTICATOR = "org.apache.cassandra.auth.AllowAllAuthenticator";
    public static final String DEFAULT_AUTHORIZER = "org.apache.cassandra.auth.AllowAllAuthorizer";
    public static final String DEFAULT_COMMITLOG_PROPS_FILE = "/conf/commitlog_archiving.properties";
    private final String DEFAULT_CASS_HOME_DIR = "/etc/cassandra";
    private final String DEFAULT_CASS_START_SCRIPT = "/etc/init.d/cassandra start";
    private final String DEFAULT_CASS_STOP_SCRIPT = "/etc/init.d/cassandra stop";
    private final String DEFAULT_BACKUP_LOCATION = "backup";
    private final String DEFAULT_BUCKET_NAME = "cassandra-archive";
    private List<String> DEFAULT_AVAILABILITY_ZONES = ImmutableList.of();
    private final String DEFAULT_CASS_PROCESS_NAME = "CassandraDaemon";
    private final String DEFAULT_MAX_DIRECT_MEM = "50G";
    private final String DEFAULT_MAX_HEAP = "8G";
    private final String DEFAULT_MAX_NEWGEN_HEAP = "2G";
    private final int DEFAULT_JMX_PORT = 7199;
    private final int DEFAULT_NATIVE_PROTOCOL_PORT = 9042;
    private final int DEFAULT_STORAGE_PORT = 7000;
    private final int DEFAULT_SSL_STORAGE_PORT = 7001;
    private final int DEFAULT_BACKUP_HOUR = 12;
    private final String DEFAULT_BACKUP_CRON_EXPRESSION = "0 0 12 1/1 * ? *";
    private final int DEFAULT_BACKUP_THREADS = 2;
    private final int DEFAULT_RESTORE_THREADS = 8;
    private final int DEFAULT_BACKUP_CHUNK_SIZE = 10;
    private final int DEFAULT_BACKUP_RETENTION = 0;
    private final int DEFAULT_VNODE_NUM_TOKENS = 1;
    private final int DEFAULT_HINTS_MAX_THREADS = 2;
    private final int DEFAULT_HINTS_THROTTLE_KB = 1024;
    private final String DEFAULT_INTERNODE_COMPRESSION = "all";
    private final int DEFAULT_REMEDIATE_DEAD_CASSANDRA_RATE_S = 3600;
    private static final int DEFAULT_INDEX_INTERVAL = 256;
    private static final int DEFAULT_STREAMING_SOCKET_TIMEOUT_IN_MS = 86400000;
    private static final int DEFAULT_TOMBSTONE_WARNING_THRESHOLD = 1000;
    private static final int DEFAULT_TOMBSTONE_FAILURE_THRESHOLD = 100000;
    private static final boolean DEFAULT_DUAL_ACCOUNT = false;
    private final IConfigSource config;
    private static final Logger logger = LoggerFactory.getLogger(PriamConfiguration.class);
    private final ICredential provider;
    private InstanceEnvIdentity insEnvIdentity;
    private InstanceDataRetriever instanceDataRetriever;

    @Inject
    public PriamConfiguration(ICredential provider, IConfigSource config, InstanceEnvIdentity insEnvIdentity) {
        this.provider = provider;
        this.config = config;
        this.insEnvIdentity = insEnvIdentity;
    }

    @Override
    public void intialize() {
        block4: {
            try {
                if (this.insEnvIdentity.isClassic().booleanValue()) {
                    this.instanceDataRetriever = (InstanceDataRetriever)Class.forName("com.netflix.priam.identity.config.AwsClassicInstanceDataRetriever").newInstance();
                    break block4;
                }
                if (this.insEnvIdentity.isNonDefaultVpc().booleanValue()) {
                    this.instanceDataRetriever = (InstanceDataRetriever)Class.forName("com.netflix.priam.identity.config.AWSVpcInstanceDataRetriever").newInstance();
                    break block4;
                }
                throw new IllegalStateException("Unable to determine environemt (vpc, classic) for running instance.");
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception when instantiating the instance data retriever.  Msg: " + e.getLocalizedMessage());
            }
        }
        this.RAC = this.instanceDataRetriever.getRac();
        this.NETWORK_VPC = this.instanceDataRetriever.getVpcId();
        this.setupEnvVars();
        this.config.intialize(ASG_NAME, REGION);
        this.setDefaultRACList(REGION);
        this.populateProps();
        SystemUtils.createDirs(this.getBackupCommitLogLocation());
        SystemUtils.createDirs(this.getCommitLogLocation());
        SystemUtils.createDirs(this.getCacheLocation());
        SystemUtils.createDirs(this.getDataFileLocation());
        SystemUtils.createDirs(this.getHintsLocation());
        SystemUtils.createDirs(this.getLogDirLocation());
    }

    @Override
    public InstanceDataRetriever getInstanceDataRetriever() {
        return this.instanceDataRetriever;
    }

    private void setupEnvVars() {
        String string = REGION = StringUtils.isBlank((CharSequence)REGION) ? System.getProperty("EC2_REGION") : REGION;
        if (StringUtils.isBlank((CharSequence)REGION)) {
            REGION = this.RAC.substring(0, this.RAC.length() - 1);
        }
        String string2 = ASG_NAME = StringUtils.isBlank((CharSequence)ASG_NAME) ? System.getProperty("ASG_NAME") : ASG_NAME;
        if (StringUtils.isBlank((CharSequence)ASG_NAME)) {
            ASG_NAME = this.populateASGName(REGION, this.getInstanceDataRetriever().getInstanceId());
        }
        logger.info("REGION set to {}, ASG Name set to {}", (Object)REGION, (Object)ASG_NAME);
    }

    private String populateASGName(String region, String instanceId) {
        GetASGName getASGName = new GetASGName(region, instanceId);
        try {
            return (String)getASGName.call();
        }
        catch (Exception e) {
            logger.error("Failed to determine ASG name.", (Throwable)e);
            return null;
        }
    }

    public void setDefaultRACList(String region) {
        AmazonEC2Client client = new AmazonEC2Client(this.provider.getAwsCredentialProvider());
        client.setEndpoint("ec2." + region + ".amazonaws.com");
        DescribeAvailabilityZonesResult res = client.describeAvailabilityZones();
        ArrayList zone = Lists.newArrayList();
        for (AvailabilityZone reg : res.getAvailabilityZones()) {
            if (reg.getState().equals("available")) {
                zone.add(reg.getZoneName());
            }
            if (zone.size() != 3) continue;
            break;
        }
        this.DEFAULT_AVAILABILITY_ZONES = ImmutableList.copyOf((Collection)zone);
    }

    private void populateProps() {
        this.config.set(CONFIG_ASG_NAME, ASG_NAME);
        this.config.set(CONFIG_REGION_NAME, REGION);
    }

    @Override
    public String getInstanceName() {
        return this.instanceDataRetriever.getInstanceId();
    }

    @Override
    public String getCassStartupScript() {
        return this.config.get(CONFIG_CASS_START_SCRIPT, "/etc/init.d/cassandra start");
    }

    @Override
    public String getCassStopScript() {
        return this.config.get(CONFIG_CASS_STOP_SCRIPT, "/etc/init.d/cassandra stop");
    }

    @Override
    public int getGracefulDrainHealthWaitSeconds() {
        return -1;
    }

    @Override
    public int getRemediateDeadCassandraRate() {
        return this.config.get(CONFIG_REMEDIATE_DEAD_CASSANDRA_RATE_S, 3600);
    }

    @Override
    public String getCassHome() {
        return this.config.get(CONFIG_CASS_HOME_DIR, "/etc/cassandra");
    }

    @Override
    public String getBackupLocation() {
        return this.config.get(CONFIG_S3_BASE_DIR, "backup");
    }

    @Override
    public String getBackupPrefix() {
        return this.config.get(CONFIG_BUCKET_NAME, "cassandra-archive");
    }

    @Override
    public int getBackupRetentionDays() {
        return this.config.get(CONFIG_BACKUP_RETENTION, 0);
    }

    @Override
    public List<String> getBackupRacs() {
        return this.config.getList(CONFIG_BACKUP_RACS);
    }

    @Override
    public String getRestorePrefix() {
        return this.config.get(CONFIG_RESTORE_PREFIX);
    }

    @Override
    public List<String> getRestoreKeySpaces() {
        return this.config.getList(CONFIG_RESTORE_KEYSPACES);
    }

    @Override
    public String getDataFileLocation() {
        return this.config.get(CONFIG_DATA_LOCATION, "/var/lib/cassandra/data");
    }

    @Override
    public String getLogDirLocation() {
        return this.config.get(CONFIG_LOGS_LOCATION, "/var/lib/cassandra/logs");
    }

    @Override
    public String getHintsLocation() {
        return this.config.get("priam.hints.location", "/var/lib/cassandra/hints");
    }

    @Override
    public String getCacheLocation() {
        return this.config.get(CONFIG_SAVE_CACHE_LOCATION, "/var/lib/cassandra/saved_caches");
    }

    @Override
    public String getCommitLogLocation() {
        return this.config.get(CONFIG_CL_LOCATION, "/var/lib/cassandra/commitlog");
    }

    @Override
    public String getBackupCommitLogLocation() {
        return this.config.get(CONFIG_CL_BK_LOCATION, "");
    }

    @Override
    public long getBackupChunkSize() {
        long size = this.config.get(CONFIG_BACKUP_CHUNK_SIZE, 10);
        return size * 1024L * 1024L;
    }

    @Override
    public int getJmxPort() {
        return this.config.get(CONFIG_JMX_LISTERN_PORT_NAME, 7199);
    }

    @Override
    public String getJmxUsername() {
        return this.config.get(CONFIG_JMX_USERNAME, "");
    }

    @Override
    public String getJmxPassword() {
        return this.config.get(CONFIG_JMX_PASSWORD, "");
    }

    @Override
    public boolean enableRemoteJMX() {
        return this.config.get(CONFIG_JMX_ENABLE_REMOTE, false);
    }

    @Override
    public int getNativeTransportPort() {
        return this.config.get(CONFIG_NATIVE_PROTOCOL_PORT, 9042);
    }

    @Override
    public int getStoragePort() {
        return this.config.get(CONFIG_STORAGE_LISTERN_PORT_NAME, 7000);
    }

    @Override
    public int getSSLStoragePort() {
        return this.config.get(CONFIG_SSL_STORAGE_LISTERN_PORT_NAME, 7001);
    }

    @Override
    public String getSnitch() {
        return this.config.get(CONFIG_ENDPOINT_SNITCH, "org.apache.cassandra.locator.Ec2Snitch");
    }

    @Override
    public String getAppName() {
        return this.config.get(CONFIG_CLUSTER_NAME, "cass_cluster");
    }

    @Override
    public String getRac() {
        return this.RAC;
    }

    @Override
    public List<String> getRacs() {
        return this.config.getList(CONFIG_AVAILABILITY_ZONES, this.DEFAULT_AVAILABILITY_ZONES);
    }

    @Override
    public String getHostname() {
        if (this.isVpcRing()) {
            return this.getInstanceDataRetriever().getPrivateIP();
        }
        return this.getInstanceDataRetriever().getPublicHostname();
    }

    @Override
    public String getHeapSize() {
        return this.config.get(CONFIG_MAX_HEAP_SIZE + this.getInstanceDataRetriever().getInstanceType(), "8G");
    }

    @Override
    public String getHeapNewSize() {
        return this.config.get(CONFIG_NEW_MAX_HEAP_SIZE + this.getInstanceDataRetriever().getInstanceType(), "2G");
    }

    @Override
    public String getMaxDirectMemory() {
        return this.config.get(CONFIG_DIRECT_MAX_HEAP_SIZE + this.getInstanceDataRetriever().getInstanceType(), "50G");
    }

    @Override
    public int getBackupHour() {
        return this.config.get(CONFIG_BACKUP_HOUR, 12);
    }

    @Override
    public String getBackupCronExpression() {
        return this.config.get(CONFIG_BACKUP_CRON_EXPRESSION, "0 0 12 1/1 * ? *");
    }

    @Override
    public SchedulerType getBackupSchedulerType() throws UnsupportedTypeException {
        String schedulerType = this.config.get(CONFIG_BACKUP_SCHEDULE_TYPE, SchedulerType.HOUR.getSchedulerType());
        return SchedulerType.lookup(schedulerType);
    }

    @Override
    public GCType getGCType() throws UnsupportedTypeException {
        String gcType = this.config.get("priam.gc.type", GCType.CMS.getGcType());
        return GCType.lookup(gcType);
    }

    @Override
    public Map<String, JVMOption> getJVMExcludeSet() {
        return JVMOptionsTuner.parseJVMOptions(this.config.get("priam.jvm.options.exclude"));
    }

    @Override
    public Map<String, JVMOption> getJVMUpsertSet() {
        return JVMOptionsTuner.parseJVMOptions(this.config.get("priam.jvm.options.upsert"));
    }

    @Override
    public SchedulerType getFlushSchedulerType() throws UnsupportedTypeException {
        String schedulerType = this.config.get("priam.flush.schedule.type", SchedulerType.HOUR.getSchedulerType());
        return SchedulerType.lookup(schedulerType);
    }

    @Override
    public String getFlushCronExpression() {
        return this.config.get("priam.flush.cron", "-1");
    }

    @Override
    public String getCompactionCronExpression() {
        return this.config.get("priam.compaction.cron", "-1");
    }

    @Override
    public String getCompactionIncludeCFList() {
        return this.config.get("priam.compaction.cf.include");
    }

    @Override
    public String getCompactionExcludeCFList() {
        return this.config.get("priam.compaction.cf.exclude");
    }

    @Override
    public String getSnapshotKeyspaceFilters() {
        return this.config.get(CONFIG_SNAPSHOT_KEYSPACE_FILTER);
    }

    @Override
    public String getSnapshotCFFilter() throws IllegalArgumentException {
        return this.config.get(CONFIG_SNAPSHOT_CF_FILTER);
    }

    @Override
    public String getIncrementalKeyspaceFilters() {
        return this.config.get(CONFIG_INCREMENTAL_KEYSPACE_FILTER);
    }

    @Override
    public String getIncrementalCFFilter() {
        return this.config.get(CONFIG_INCREMENTAL_CF_FILTER);
    }

    @Override
    public String getRestoreKeyspaceFilter() {
        return this.config.get(CONFIG_RESTORE_KEYSPACE_FILTER);
    }

    @Override
    public String getRestoreCFFilter() {
        return this.config.get(CONFIG_RESTORE_CF_FILTER);
    }

    @Override
    public String getRestoreSnapshot() {
        return this.config.get(CONFIG_AUTO_RESTORE_SNAPSHOTNAME, "");
    }

    @Override
    public boolean isRestoreEncrypted() {
        return this.config.get("priam.encrypted.restore.enabled", false);
    }

    @Override
    public String getSDBInstanceIdentityRegion() {
        return this.config.get(SDB_INSTANCE_INDENTITY_REGION_NAME, "us-east-1");
    }

    @Override
    public String getDC() {
        return this.config.get(CONFIG_REGION_NAME, "");
    }

    @Override
    public void setDC(String region) {
        this.config.set(CONFIG_REGION_NAME, region);
    }

    @Override
    public boolean isMultiDC() {
        return this.config.get(CONFIG_MR_ENABLE, false);
    }

    @Override
    public int getMaxBackupUploadThreads() {
        return this.config.get(CONFIG_BACKUP_THREADS, 2);
    }

    @Override
    public int getMaxBackupDownloadThreads() {
        return this.config.get(CONFIG_RESTORE_THREADS, 8);
    }

    @Override
    public boolean isRestoreClosestToken() {
        return this.config.get(CONFIG_RESTORE_CLOSEST_TOKEN, false);
    }

    @Override
    public String getASGName() {
        return this.config.get(CONFIG_ASG_NAME, "");
    }

    @Override
    public String getSiblingASGNames() {
        return this.config.get(CONFIG_SIBLING_ASG_NAMES, ",");
    }

    @Override
    public String getACLGroupName() {
        return this.config.get(CONFIG_ACL_GROUP_NAME, this.getAppName());
    }

    @Override
    public boolean isIncrBackup() {
        return this.config.get(CONFIG_INCR_BK_ENABLE, true);
    }

    @Override
    public String getHostIP() {
        if (this.isVpcRing()) {
            return this.getInstanceDataRetriever().getPrivateIP();
        }
        return this.getInstanceDataRetriever().getPublicIP();
    }

    @Override
    public int getUploadThrottle() {
        return this.config.get(CONFIG_THROTTLE_UPLOAD_PER_SECOND, Integer.MAX_VALUE);
    }

    @Override
    public boolean isLocalBootstrapEnabled() {
        return this.config.get(CONFIG_LOAD_LOCAL_PROPERTIES, false);
    }

    @Override
    public int getInMemoryCompactionLimit() {
        return this.config.get(CONFIG_IN_MEMORY_COMPACTION_LIMIT, 128);
    }

    @Override
    public int getCompactionThroughput() {
        return this.config.get(CONFIG_COMPACTION_THROUHPUT, 8);
    }

    @Override
    public int getMaxHintWindowInMS() {
        return this.config.get(CONFIG_MAX_HINT_WINDOW_IN_MS, 10800000);
    }

    @Override
    public int getHintedHandoffThrottleKb() {
        return this.config.get(CONFIG_HINTS_THROTTLE_KB, 1024);
    }

    public int getMaxHintThreads() {
        return this.config.get(CONFIG_MAX_HINT_THREADS, 2);
    }

    @Override
    public String getBootClusterName() {
        return this.config.get(CONFIG_BOOTCLUSTER_NAME, "");
    }

    @Override
    public String getSeedProviderName() {
        return this.config.get(CONFIG_SEED_PROVIDER_NAME, "com.netflix.priam.cassandra.extensions.NFSeedProvider");
    }

    @Override
    public double getMemtableCleanupThreshold() {
        return this.config.get(CONFIG_MEMTABLE_CLEANUP_THRESHOLD, 0.11);
    }

    @Override
    public int getStreamingThroughputMB() {
        return this.config.get(CONFIG_STREAMING_THROUGHPUT_MB, 400);
    }

    @Override
    public String getPartitioner() {
        return this.config.get(CONFIG_PARTITIONER, "org.apache.cassandra.dht.RandomPartitioner");
    }

    @Override
    public String getKeyCacheSizeInMB() {
        return this.config.get(CONFIG_KEYCACHE_SIZE);
    }

    @Override
    public String getKeyCacheKeysToSave() {
        return this.config.get(CONFIG_KEYCACHE_COUNT);
    }

    @Override
    public String getRowCacheSizeInMB() {
        return this.config.get(CONFIG_ROWCACHE_SIZE);
    }

    @Override
    public String getRowCacheKeysToSave() {
        return this.config.get(CONFIG_ROWCACHE_COUNT);
    }

    @Override
    public String getCassProcessName() {
        return this.config.get(CONFIG_CASS_PROCESS_NAME, "CassandraDaemon");
    }

    public int getNumTokens() {
        return this.config.get(CONFIG_VNODE_NUM_TOKENS, 1);
    }

    @Override
    public String getYamlLocation() {
        return this.config.get(CONFIG_YAML_LOCATION, this.getCassHome() + "/conf/cassandra.yaml");
    }

    @Override
    public String getJVMOptionsFileLocation() {
        return this.config.get("priam.jvm.options.location", this.getCassHome() + "/conf/jvm-server.options");
    }

    @Override
    public String getAuthenticator() {
        return this.config.get(CONFIG_AUTHENTICATOR, DEFAULT_AUTHENTICATOR);
    }

    @Override
    public String getAuthorizer() {
        return this.config.get(CONFIG_AUTHORIZER, DEFAULT_AUTHORIZER);
    }

    @Override
    public boolean doesCassandraStartManually() {
        return this.config.get(CONFIG_CASS_MANUAL_START_ENABLE, false);
    }

    @Override
    public String getInternodeCompression() {
        return this.config.get(CONFIG_INTERNODE_COMPRESSION, "all");
    }

    @Override
    public void setRestorePrefix(String prefix) {
        this.config.set(CONFIG_RESTORE_PREFIX, prefix);
    }

    @Override
    public boolean isBackingUpCommitLogs() {
        return this.config.get(CONFIG_COMMITLOG_BKUP_ENABLED, false);
    }

    @Override
    public String getCommitLogBackupPropsFile() {
        return this.config.get(CONFIG_COMMITLOG_PROPS_FILE, this.getCassHome() + DEFAULT_COMMITLOG_PROPS_FILE);
    }

    @Override
    public String getCommitLogBackupArchiveCmd() {
        return this.config.get(CONFIG_COMMITLOG_ARCHIVE_CMD, "/bin/ln %path /mnt/data/backup/%name");
    }

    @Override
    public String getCommitLogBackupRestoreCmd() {
        return this.config.get(CONFIG_COMMITLOG_RESTORE_CMD, "/bin/mv %from %to");
    }

    @Override
    public String getCommitLogBackupRestoreFromDirs() {
        return this.config.get(CONFIG_COMMITLOG_RESTORE_DIRS, "/mnt/data/backup/commitlog/");
    }

    @Override
    public String getCommitLogBackupRestorePointInTime() {
        return this.config.get(CONFIG_COMMITLOG_RESTORE_POINT_IN_TIME, "");
    }

    @Override
    public int maxCommitLogsRestore() {
        return this.config.get(CONFIG_COMMITLOG_RESTORE_MAX, 10);
    }

    @Override
    public boolean isVpcRing() {
        return this.config.get(CONFIG_VPC_RING, false);
    }

    @Override
    public void setRestoreKeySpaces(List<String> keyspaces) {
        if (keyspaces == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyspaces.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(keyspaces.get(i));
        }
        this.config.set(CONFIG_RESTORE_KEYSPACES, sb.toString());
    }

    @Override
    public boolean isClientSslEnabled() {
        return this.config.get(CONFIG_CLIENT_SSL_ENABLED, false);
    }

    @Override
    public String getInternodeEncryption() {
        return this.config.get(CONFIG_INTERNODE_ENCRYPTION, "none");
    }

    @Override
    public boolean isDynamicSnitchEnabled() {
        return this.config.get(CONFIG_DSNITCH_ENABLED, true);
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return this.config.get(CONFIG_NATIVE_PROTOCOL_ENABLED, false);
    }

    @Override
    public int getConcurrentReadsCnt() {
        return this.config.get(CONFIG_CONCURRENT_READS, 32);
    }

    @Override
    public int getConcurrentWritesCnt() {
        return this.config.get(CONFIG_CONCURRENT_WRITES, 32);
    }

    @Override
    public int getConcurrentCompactorsCnt() {
        int cpus = Runtime.getRuntime().availableProcessors();
        return this.config.get(CONFIG_CONCURRENT_COMPACTORS, cpus);
    }

    @Override
    public int getIndexInterval() {
        return this.config.get(CONFIG_INDEX_INTERVAL, 256);
    }

    @Override
    public int getCompactionLargePartitionWarnThresholdInMB() {
        return this.config.get("priam.compaction.large.partition.warn.threshold", 100);
    }

    @Override
    public String getExtraConfigParams() {
        return this.config.get(CONFIG_EXTRA_PARAMS);
    }

    @Override
    public Map<String, String> getExtraEnvParams() {
        String envParams = this.config.get(CONFIG_EXTRA_ENV_PARAMS);
        if (envParams == null) {
            logger.info("getExtraEnvParams: No extra env params");
            return null;
        }
        HashMap<String, String> extraEnvParamsMap = new HashMap<String, String>();
        String[] pairs = envParams.split(",");
        logger.info("getExtraEnvParams: Extra cass params. From config :{}", (Object)envParams);
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i].split("=");
            if (pair.length <= 1) continue;
            String priamKey = pair[0];
            String cassKey = pair[1];
            String cassVal = this.config.get(priamKey);
            logger.info("getExtraEnvParams: Start-up/ env params: Priamkey[{}], CassStartupKey[{}], Val[{}]", new Object[]{priamKey, cassKey, cassVal});
            if (StringUtils.isBlank((CharSequence)cassKey) || StringUtils.isBlank((CharSequence)cassVal)) continue;
            extraEnvParamsMap.put(cassKey, cassVal);
        }
        return extraEnvParamsMap;
    }

    @Override
    public String getCassYamlVal(String priamKey) {
        return this.config.get(priamKey);
    }

    @Override
    public boolean getAutoBoostrap() {
        return this.config.get(CONFIG_AUTO_BOOTSTRAP, true);
    }

    @Override
    public String getDseClusterType() {
        return this.config.get("priam.dse.cluster.type." + ASG_NAME, "cassandra");
    }

    @Override
    public boolean isCreateNewTokenEnable() {
        return this.config.get(CONFIG_CREATE_NEW_TOKEN_ENABLE, true);
    }

    @Override
    public String getPrivateKeyLocation() {
        return this.config.get(CONFIG_PRIKEY_LOC);
    }

    @Override
    public String getRestoreSourceType() {
        return this.config.get(CONFIG_RESTORE_SOURCE_TYPE);
    }

    @Override
    public boolean isEncryptBackupEnabled() {
        return this.config.get(CONFIG_ENCRYPTED_BACKUP_ENABLED, false);
    }

    @Override
    public String getAWSRoleAssumptionArn() {
        return this.config.get(CONFIG_S3_ROLE_ASSUMPTION_ARN);
    }

    @Override
    public String getClassicEC2RoleAssumptionArn() {
        return this.config.get(CONFIG_EC2_ROLE_ASSUMPTION_ARN);
    }

    @Override
    public String getVpcEC2RoleAssumptionArn() {
        return this.config.get(CONFIG_VPC_ROLE_ASSUMPTION_ARN);
    }

    @Override
    public boolean isDualAccount() {
        return this.config.get(CONFIG_DUAL_ACCOUNT, false);
    }

    @Override
    public String getGcsServiceAccountId() {
        return this.config.get(CONFIG_GCS_SERVICE_ACCT_ID);
    }

    @Override
    public String getGcsServiceAccountPrivateKeyLoc() {
        return this.config.get(CONFIG_GCS_SERVICE_ACCT_PRIVATE_KEY_LOC, "/apps/tomcat/conf/gcsentryptedkey.p12");
    }

    @Override
    public String getPgpPasswordPhrase() {
        return this.config.get(CONFIG_PGP_PASSWORD_PHRASE);
    }

    @Override
    public String getPgpPublicKeyLoc() {
        return this.config.get(CONFIG_PGP_PUB_KEY_LOC);
    }

    @Override
    public String getVpcId() {
        return this.NETWORK_VPC;
    }

    @Override
    public Boolean isIncrBackupParallelEnabled() {
        return this.config.get("priam.incremental.bkup.parallel", false);
    }

    @Override
    public int getIncrementalBkupMaxConsumers() {
        return this.config.get("priam.incremental.bkup.max.consumers", 4);
    }

    @Override
    public int getUncrementalBkupQueueSize() {
        return this.config.get("priam.incremental.bkup.queue.size", 100000);
    }

    @Override
    public int getTombstoneWarnThreshold() {
        return this.config.get(CONFIG_TOMBSTONE_WARNING_THRESHOLD, 1000);
    }

    @Override
    public int getTombstoneFailureThreshold() {
        return this.config.get(CONFIG_TOMBSTONE_FAILURE_THRESHOLD, 100000);
    }

    @Override
    public int getStreamingSocketTimeoutInMS() {
        return this.config.get(CONFIG_STREAMING_SOCKET_TIMEOUT_IN_MS, 86400000);
    }

    @Override
    public String getFlushKeyspaces() {
        return this.config.get("priam.flush.keyspaces");
    }

    @Override
    public String getFlushInterval() {
        return this.config.get("priam.flush.interval");
    }

    @Override
    public String getBackupStatusFileLoc() {
        return this.config.get(CONFIG_BACKUP_STATUS_FILE_LOCATION, this.getDataFileLocation() + File.separator + "backup.status");
    }

    @Override
    public boolean useSudo() {
        return this.config.get(CONFIG_CASS_USE_SUDO, true);
    }

    @Override
    public String getBackupNotificationTopicArn() {
        return this.config.get("priam.backup.notification.topic.arn", "");
    }

    @Override
    public boolean isPostRestoreHookEnabled() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_ENABLED, false);
    }

    @Override
    public String getPostRestoreHook() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK);
    }

    @Override
    public String getPostRestoreHookHeartbeatFileName() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_HEARTBEAT_FILENAME, this.getDataFileLocation() + File.separator + "postrestorehook_heartbeat");
    }

    @Override
    public String getPostRestoreHookDoneFileName() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_DONE_FILENAME, this.getDataFileLocation() + File.separator + "postrestorehook_done");
    }

    @Override
    public int getPostRestoreHookTimeOutInDays() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_TIMEOUT_IN_DAYS, 2);
    }

    @Override
    public int getPostRestoreHookHeartBeatTimeoutInMs() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_HEARTBEAT_TIMEOUT_MS, 120000);
    }

    @Override
    public int getPostRestoreHookHeartbeatCheckFrequencyInMs() {
        return this.config.get(CONFIG_POST_RESTORE_HOOK_HEARTBEAT_CHECK_FREQUENCY_MS, 120000);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.config.get("priam." + key, defaultValue);
    }

    private class GetASGName
    extends RetryableCallable<String> {
        private static final int NUMBER_OF_RETRIES = 15;
        private static final long WAIT_TIME = 30000L;
        private final String region;
        private final String instanceId;
        private final AmazonEC2 client;

        public GetASGName(String region, String instanceId) {
            super(15, 30000L);
            this.region = region;
            this.instanceId = instanceId;
            this.client = new AmazonEC2Client(PriamConfiguration.this.provider.getAwsCredentialProvider());
            this.client.setEndpoint("ec2." + region + ".amazonaws.com");
        }

        @Override
        public String retriableCall() throws IllegalStateException {
            DescribeInstancesRequest desc = new DescribeInstancesRequest().withInstanceIds(new String[]{this.instanceId});
            DescribeInstancesResult res = this.client.describeInstances(desc);
            for (Reservation resr : res.getReservations()) {
                for (Instance ins : resr.getInstances()) {
                    for (Tag tag : ins.getTags()) {
                        if (!tag.getKey().equals("aws:autoscaling:groupName")) continue;
                        return tag.getValue();
                    }
                }
            }
            logger.warn("Couldn't determine ASG name");
            throw new IllegalStateException("Couldn't determine ASG name");
        }
    }
}

