/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.configSource;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.priam.configSource.AbstractConfigSource;
import com.netflix.priam.cred.ICredential;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleDBConfigSource
extends AbstractConfigSource {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleDBConfigSource.class.getName());
    private static final String DOMAIN = "PriamProperties";
    private final Map<String, String> data = Maps.newConcurrentMap();
    private final ICredential provider;

    @Inject
    public SimpleDBConfigSource(ICredential provider) {
        this.provider = provider;
    }

    @Override
    public void intialize(String asgName, String region) {
        super.intialize(asgName, region);
        AmazonSimpleDB simpleDBClient = (AmazonSimpleDB)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClient.builder().withCredentials(this.provider.getAwsCredentialProvider())).build();
        String nextToken = null;
        String appid = asgName.lastIndexOf(45) > 0 ? asgName.substring(0, asgName.indexOf(45)) : asgName;
        logger.info("appid used to fetch properties is: {}", (Object)appid);
        do {
            String ALL_QUERY = "select * from PriamProperties where appId='%s'";
            SelectRequest request = new SelectRequest(String.format(ALL_QUERY, appid));
            request.setNextToken(nextToken);
            SelectResult result = simpleDBClient.select(request);
            nextToken = result.getNextToken();
            Iterator itemiter = result.getItems().iterator();
            while (itemiter.hasNext()) {
                this.addProperty((Item)itemiter.next());
            }
        } while (nextToken != null);
    }

    private void addProperty(Item item) {
        Iterator attrs = item.getAttributes().iterator();
        String prop = "";
        String value = "";
        String dc = "";
        while (attrs.hasNext()) {
            Attribute att = (Attribute)attrs.next();
            if (att.getName().equals("property")) {
                prop = att.getValue();
                continue;
            }
            if (att.getName().equals("value")) {
                value = att.getValue();
                continue;
            }
            if (!att.getName().equals("region")) continue;
            dc = att.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)dc) && !dc.equals(this.getRegion())) {
            return;
        }
        if (this.data.containsKey(prop) && StringUtils.isBlank((CharSequence)dc)) {
            return;
        }
        this.data.put(prop, value);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public String get(String key) {
        return this.data.get(key);
    }

    @Override
    public void set(String key, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value can not be null for configurations.");
        this.data.put(key, value);
    }

    private static class Attributes {
        public static final String APP_ID = "appId";
        public static final String PROPERTY = "property";
        public static final String PROPERTY_VALUE = "value";
        public static final String REGION = "region";

        private Attributes() {
        }
    }
}

