/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.defaultimpl;

import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.utils.JMXNodeTool;
import com.netflix.priam.utils.RetryableCallable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraOperations {
    private static final Logger logger = LoggerFactory.getLogger(CassandraOperations.class);
    private IConfiguration configuration;

    @Inject
    CassandraOperations(IConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void takeSnapshot(final String snapshotName) throws Exception {
        try {
            new RetryableCallable<Void>(6, 10000L){

                @Override
                public Void retriableCall() throws Exception {
                    JMXNodeTool nodetool = JMXNodeTool.instance(CassandraOperations.this.configuration);
                    nodetool.takeSnapshot(snapshotName, null, Collections.emptyMap(), new String[0]);
                    return null;
                }
            }.call();
        }
        catch (Exception e) {
            logger.error("Error while taking snapshot {}. Asking Cassandra to clear snapshot to avoid accumulation of snapshots.", (Object)snapshotName);
            this.clearSnapshot(snapshotName);
            throw e;
        }
    }

    public void clearSnapshot(final String snapshotTag) throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                JMXNodeTool nodetool = JMXNodeTool.instance(CassandraOperations.this.configuration);
                nodetool.clearSnapshot(snapshotTag, new String[0]);
                return null;
            }
        }.call();
    }

    public List<String> getKeyspaces() throws Exception {
        return (List)new RetryableCallable<List<String>>(){

            @Override
            public List<String> retriableCall() throws Exception {
                try (JMXNodeTool nodeTool = JMXNodeTool.instance(CassandraOperations.this.configuration);){
                    List list = nodeTool.getKeyspaces();
                    return list;
                }
            }
        }.call();
    }

    public Map<String, List<String>> getColumnfamilies() throws Exception {
        return (Map)new RetryableCallable<Map<String, List<String>>>(){

            @Override
            public Map<String, List<String>> retriableCall() throws Exception {
                try (JMXNodeTool nodeTool = JMXNodeTool.instance(CassandraOperations.this.configuration);){
                    HashMap<String, List<String>> columnfamilies = new HashMap<String, List<String>>();
                    Iterator columnfamilyStoreMBean = nodeTool.getColumnFamilyStoreMBeanProxies();
                    columnfamilyStoreMBean.forEachRemaining(entry -> {
                        columnfamilies.putIfAbsent((String)entry.getKey(), new ArrayList());
                        ((List)columnfamilies.get(entry.getKey())).add(((ColumnFamilyStoreMBean)entry.getValue()).getColumnFamilyName());
                    });
                    HashMap<String, List<String>> hashMap = columnfamilies;
                    return hashMap;
                }
            }
        }.call();
    }

    public void forceKeyspaceCompaction(final String keyspaceName, final String ... columnfamilies) throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                try (JMXNodeTool nodeTool = JMXNodeTool.instance(CassandraOperations.this.configuration);){
                    nodeTool.forceKeyspaceCompaction(false, keyspaceName, columnfamilies);
                    Void void_ = null;
                    return void_;
                }
            }
        }.call();
    }

    public void forceKeyspaceFlush(final String keyspaceName) throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                try (JMXNodeTool nodeTool = JMXNodeTool.instance(CassandraOperations.this.configuration);){
                    nodeTool.forceKeyspaceFlush(keyspaceName, new String[0]);
                    Void void_ = null;
                    return void_;
                }
            }
        }.call();
    }
}

