/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.google;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredentialGeneric;

public class GcsCredential
implements ICredentialGeneric {
    private IConfiguration config;

    @Inject
    public GcsCredential(IConfiguration config) {
        this.config = config;
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialProvider() {
        return null;
    }

    @Override
    public byte[] getValue(ICredentialGeneric.KEY key) {
        if (key == null) {
            throw new NullPointerException("Credential key cannot be null.");
        }
        if (key.equals((Object)ICredentialGeneric.KEY.GCS_PRIVATE_KEY_LOC)) {
            return this.config.getGcsServiceAccountPrivateKeyLoc().getBytes();
        }
        if (key.equals((Object)ICredentialGeneric.KEY.GCS_SERVICE_ID)) {
            return this.config.getGcsServiceAccountId().getBytes();
        }
        throw new IllegalArgumentException("Key value not supported.");
    }
}

