/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.utils.ITokenManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleRing {
    private static final Logger logger = LoggerFactory.getLogger(DoubleRing.class);
    private static File TMP_BACKUP_FILE;
    private final IConfiguration config;
    private final IPriamInstanceFactory<PriamInstance> factory;
    private final ITokenManager tokenManager;

    @Inject
    public DoubleRing(IConfiguration config, IPriamInstanceFactory factory, ITokenManager tokenManager) {
        this.config = config;
        this.factory = factory;
        this.tokenManager = tokenManager;
    }

    public void doubleSlots() {
        List<PriamInstance> local = this.filteredRemote(this.factory.getAllIds(this.config.getAppName()));
        for (PriamInstance priamInstance : local) {
            this.factory.delete(priamInstance);
        }
        int hash = this.tokenManager.regionOffset(this.config.getDC());
        for (PriamInstance data : local) {
            int slot = (data.getId() - hash) * 2;
            this.factory.create(data.getApp(), hash + slot, data.getInstanceId(), data.getHostName(), data.getHostIP(), data.getRac(), data.getVolumes(), data.getToken());
        }
        int n = local.size() * 2;
        for (PriamInstance data : this.filteredRemote(this.factory.getAllIds(this.config.getAppName()))) {
            int currentSlot = data.getId() - hash;
            int new_slot = currentSlot + 3 > n ? currentSlot + 3 - n : currentSlot + 3;
            String token = this.tokenManager.createToken(new_slot, n, this.config.getDC());
            this.factory.create(data.getApp(), new_slot + hash, "new_slot", this.config.getHostname(), this.config.getHostIP(), data.getRac(), null, token);
        }
    }

    private List<PriamInstance> filteredRemote(List<PriamInstance> lst) {
        ArrayList local = Lists.newArrayList();
        for (PriamInstance data : lst) {
            if (!data.getDC().equals(this.config.getDC())) continue;
            local.add(data);
        }
        return local;
    }

    public void backup() throws IOException {
        TMP_BACKUP_FILE = File.createTempFile("Backup-instance-data", ".dat");
        FileOutputStream out = new FileOutputStream(TMP_BACKUP_FILE);
        ObjectOutputStream stream = new ObjectOutputStream(out);
        try {
            stream.writeObject(this.filteredRemote(this.factory.getAllIds(this.config.getAppName())));
            logger.info("Wrote the backup of the instances to: {}", (Object)TMP_BACKUP_FILE.getAbsolutePath());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() throws IOException, ClassNotFoundException {
        for (PriamInstance data : this.filteredRemote(this.factory.getAllIds(this.config.getAppName()))) {
            this.factory.delete(data);
        }
        FileInputStream in = new FileInputStream(TMP_BACKUP_FILE);
        ObjectInputStream stream = new ObjectInputStream(in);
        try {
            List allInstances = (List)stream.readObject();
            for (PriamInstance data : allInstances) {
                this.factory.create(data.getApp(), data.getId(), data.getInstanceId(), data.getHostName(), data.getHostIP(), data.getRac(), data.getVolumes(), data.getToken());
            }
            logger.info("Sucecsfully restored the Instances from the backup: {}", (Object)TMP_BACKUP_FILE.getAbsolutePath());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

