/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.notification;

import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.google.inject.Inject;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.notification.BackupEvent;
import com.netflix.priam.notification.EventObserver;
import com.netflix.priam.notification.INotificationService;
import java.util.HashMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupNotificationMgr
implements EventObserver<BackupEvent> {
    private static final String SUCCESS_VAL = "success";
    private static final String FAILED_VAL = "failed";
    private static final String STARTED = "started";
    private static final Logger logger = LoggerFactory.getLogger(BackupNotificationMgr.class);
    private final IConfiguration config;
    private INotificationService notificationService;

    @Inject
    public BackupNotificationMgr(IConfiguration config, INotificationService notificationService) {
        this.config = config;
        this.notificationService = notificationService;
    }

    private void notify(AbstractBackupPath abp, String uploadStatus) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("s3bucketname", (Object)this.config.getBackupPrefix());
            jsonObject.put("s3clustername", (Object)abp.getClusterName());
            jsonObject.put("s3namespace", (Object)abp.getRemotePath());
            jsonObject.put("keyspace", (Object)abp.getKeyspace());
            jsonObject.put("cf", (Object)abp.getColumnFamily());
            jsonObject.put("region", (Object)abp.getRegion());
            jsonObject.put("rack", (Object)this.config.getRac());
            jsonObject.put("token", (Object)abp.getToken());
            jsonObject.put("filename", (Object)abp.getFileName());
            jsonObject.put("uncompressfilesize", abp.getSize());
            jsonObject.put("compressfilesize", abp.getCompressedFileSize());
            jsonObject.put("backuptype", (Object)abp.getType().name());
            jsonObject.put("uploadstatus", (Object)uploadStatus);
            HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
            messageAttributes.putIfAbsent("s3clustername", new MessageAttributeValue().withDataType("String").withStringValue(abp.getClusterName()));
            messageAttributes.putIfAbsent("backuptype", new MessageAttributeValue().withDataType("String").withStringValue(abp.getType().name()));
            this.notificationService.notify(jsonObject.toString(), messageAttributes);
        }
        catch (JSONException exception) {
            logger.error("JSON exception during generation of notification for upload {}.  Local file {}. Ignoring to continue with rest of backup.  Msg: {}", new Object[]{uploadStatus, abp.getFileName(), exception.getLocalizedMessage()});
        }
    }

    @Override
    public void updateEventStart(BackupEvent event) {
        this.notify(event.getAbstractBackupPath(), STARTED);
    }

    @Override
    public void updateEventFailure(BackupEvent event) {
        this.notify(event.getAbstractBackupPath(), FAILED_VAL);
    }

    @Override
    public void updateEventSuccess(BackupEvent event) {
        this.notify(event.getAbstractBackupPath(), SUCCESS_VAL);
    }

    @Override
    public void updateEventStop(BackupEvent event) {
    }
}

