/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import java.net.URI;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/instances")
@Produces(value={"text/plain"})
public class PriamInstanceResource {
    private static final Logger log = LoggerFactory.getLogger(PriamInstanceResource.class);
    private final IConfiguration config;
    private final IPriamInstanceFactory<PriamInstance> factory;

    @Inject
    public PriamInstanceResource(IConfiguration config, IPriamInstanceFactory factory) {
        this.config = config;
        this.factory = factory;
    }

    @GET
    public String getInstances() {
        StringBuilder response = new StringBuilder();
        List<PriamInstance> allInstances = this.factory.getAllIds(this.config.getAppName());
        for (PriamInstance node : allInstances) {
            response.append(node.toString());
            response.append("\n");
        }
        return response.toString();
    }

    @GET
    @Path(value="{id}")
    public String getInstance(@PathParam(value="id") int id) {
        PriamInstance node = this.getByIdIfFound(id);
        return node.toString();
    }

    @POST
    public Response createInstance(@QueryParam(value="id") int id, @QueryParam(value="instanceID") String instanceID, @QueryParam(value="hostname") String hostname, @QueryParam(value="ip") String ip, @QueryParam(value="rack") String rack, @QueryParam(value="token") String token) {
        log.info("Creating instance [id={}, instanceId={}, hostname={}, ip={}, rack={}, token={}", new Object[]{id, instanceID, hostname, ip, rack, token});
        PriamInstance instance = this.factory.create(this.config.getAppName(), id, instanceID, hostname, ip, rack, null, token);
        URI uri = UriBuilder.fromPath((String)"/{id}").build(new Object[]{instance.getId()});
        return Response.created((URI)uri).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteInstance(@PathParam(value="id") int id) {
        PriamInstance instance = this.getByIdIfFound(id);
        this.factory.delete(instance);
        return Response.noContent().build();
    }

    private PriamInstance getByIdIfFound(int id) {
        PriamInstance instance = this.factory.getInstance(this.config.getAppName(), this.config.getDC(), id);
        if (instance == null) {
            throw PriamInstanceResource.notFound(String.format("No priam instance with id %s found", id));
        }
        return instance;
    }

    private static WebApplicationException notFound(String message) {
        return new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build());
    }
}

