/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingSubmitThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final long DEFAULT_SLEEP = 100L;
    private static final long DEFAULT_KEEP_ALIVE = 100L;
    private static final Logger logger = LoggerFactory.getLogger(BlockingSubmitThreadPoolExecutor.class);
    private BlockingQueue<Runnable> queue;
    private long giveupTime;
    private AtomicInteger active;

    public BlockingSubmitThreadPoolExecutor(int maximumPoolSize, BlockingQueue<Runnable> workQueue, long timeoutAdding) {
        super(maximumPoolSize, maximumPoolSize, 100L, TimeUnit.SECONDS, workQueue);
        this.queue = workQueue;
        this.giveupTime = timeoutAdding;
        this.active = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> task) {
        BlockingSubmitThreadPoolExecutor blockingSubmitThreadPoolExecutor = this;
        synchronized (blockingSubmitThreadPoolExecutor) {
            this.active.incrementAndGet();
            long timeout = 0L;
            while (this.queue.remainingCapacity() == 0) {
                try {
                    if (timeout <= this.giveupTime) {
                        Thread.sleep(100L);
                        timeout += 100L;
                        continue;
                    }
                    throw new RuntimeException("Timed out because TPE is too busy...");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.submit(task);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.active.decrementAndGet();
    }

    public void sleepTillEmpty() {
        long timeout = 0L;
        while (!this.queue.isEmpty() || this.active.get() > 0) {
            try {
                if (timeout <= this.giveupTime) {
                    Thread.sleep(100L);
                    timeout += 100L;
                    logger.debug("After Sleeping for empty: {}, Count: {}", (Object)this.queue.size(), (Object)this.active.get());
                    continue;
                }
                throw new RuntimeException("Timed out because TPE is too busy...");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

