/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.scheduler.GuiceJobFactory;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.Sleeper;
import java.text.ParseException;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PriamScheduler {
    private static final Logger logger = LoggerFactory.getLogger(PriamScheduler.class);
    private final Scheduler scheduler;
    private final GuiceJobFactory jobFactory;
    private final Sleeper sleeper;

    @Inject
    public PriamScheduler(SchedulerFactory factory, GuiceJobFactory jobFactory, Sleeper sleeper) {
        try {
            this.scheduler = factory.getScheduler();
            this.scheduler.setJobFactory((JobFactory)jobFactory);
            this.jobFactory = jobFactory;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        this.sleeper = sleeper;
    }

    public void addTask(String name, Class<? extends Task> taskclass, TaskTimer timer) throws SchedulerException, ParseException {
        assert (timer != null) : "Cannot add scheduler task " + name + " as no timer is set";
        JobDetail job = JobBuilder.newJob().withIdentity(name, "DEFAULT").ofType(taskclass).build();
        if (timer.getCronExpression() != null && !timer.getCronExpression().isEmpty()) {
            logger.info("Scheduled task metadata.  Task name: {}, cron expression: {}", (Object)taskclass.getName(), (Object)timer.getCronExpression());
        } else {
            logger.info("Scheduled task metadata.  Task name: {}", (Object)taskclass.getName());
        }
        this.scheduler.scheduleJob(job, timer.getTrigger());
    }

    public void addTaskWithDelay(final String name, Class<? extends Task> taskclass, final TaskTimer timer, final int delayInSeconds) throws SchedulerException, ParseException {
        assert (timer != null) : "Cannot add scheduler task " + name + " as no timer is set";
        final JobDetail job = JobBuilder.newJob().withIdentity(name, "DEFAULT").ofType(taskclass).build();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PriamScheduler.this.sleeper.sleepQuietly((long)delayInSeconds * 1000L);
                    PriamScheduler.this.scheduler.scheduleJob(job, timer.getTrigger());
                }
                catch (SchedulerException e) {
                    logger.warn("problem occurred while scheduling a job with name {}", (Object)name, (Object)e);
                }
                catch (ParseException e) {
                    logger.warn("problem occurred while parsing a job with name {}", (Object)name, (Object)e);
                }
            }
        }).start();
    }

    public void runTaskNow(Class<? extends Task> taskclass) throws Exception {
        ((Task)this.jobFactory.guice.getInstance(taskclass)).execute(null);
    }

    public void deleteTask(String name) throws SchedulerException, ParseException {
        this.scheduler.deleteJob(new JobKey(name, "DEFAULT"));
    }

    public final Scheduler getScheduler() {
        return this.scheduler;
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }
}

