/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.scheduler;

import com.netflix.priam.scheduler.UnsupportedTypeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SchedulerType {
    HOUR("HOUR"),
    CRON("CRON");

    private static final Logger logger;
    private final String schedulerType;

    private SchedulerType(String schedulerType) {
        this.schedulerType = schedulerType.toUpperCase();
    }

    public static SchedulerType lookup(String schedulerType, boolean acceptNullOrEmpty, boolean acceptIllegalValue) throws UnsupportedTypeException {
        if (StringUtils.isEmpty((CharSequence)schedulerType)) {
            if (acceptNullOrEmpty) {
                return null;
            }
            String message = String.format("%s is not a supported SchedulerType. Supported values are %s", schedulerType, SchedulerType.getSupportedValues());
            logger.error(message);
            throw new UnsupportedTypeException(message);
        }
        try {
            return SchedulerType.valueOf(schedulerType.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            String message = String.format("%s is not a supported SchedulerType. Supported values are %s", schedulerType, SchedulerType.getSupportedValues());
            if (acceptIllegalValue) {
                message = message + ". Since acceptIllegalValue is set to True, returning NULL instead.";
                logger.error(message);
                return null;
            }
            logger.error(message);
            throw new UnsupportedTypeException(message, ex);
        }
    }

    private static String getSupportedValues() {
        StringBuffer supportedValues = new StringBuffer();
        boolean first = true;
        for (SchedulerType type : SchedulerType.values()) {
            if (!first) {
                supportedValues.append(",");
            }
            supportedValues.append((Object)type);
            first = false;
        }
        return supportedValues.toString();
    }

    public static SchedulerType lookup(String schedulerType) throws UnsupportedTypeException {
        return SchedulerType.lookup(schedulerType, false, false);
    }

    public String getSchedulerType() {
        return this.schedulerType;
    }

    static {
        logger = LoggerFactory.getLogger(SchedulerType.class);
    }
}

