/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.priam.backup.SnapshotBackup;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.restore.Restore;
import com.netflix.priam.tuner.ICassandraTuner;
import com.netflix.priam.tuner.JVMOptionsTuner;
import com.netflix.priam.tuner.PropertiesFileTuner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class StandardTuner
implements ICassandraTuner {
    private static final Logger logger = LoggerFactory.getLogger(StandardTuner.class);
    protected final IConfiguration config;

    @Inject
    public StandardTuner(IConfiguration config) {
        this.config = config;
    }

    @Override
    public void writeAllProperties(String yamlLocation, String hostname, String seedProvider) throws Exception {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        File yamlFile = new File(yamlLocation);
        Map map = (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
        map.put("cluster_name", this.config.getAppName());
        map.put("storage_port", this.config.getStoragePort());
        map.put("ssl_storage_port", this.config.getSSLStoragePort());
        map.put("start_native_transport", this.config.isNativeTransportEnabled());
        map.put("native_transport_port", this.config.getNativeTransportPort());
        map.put("listen_address", hostname);
        map.put("rpc_address", hostname);
        if (!Restore.isRestoreEnabled(this.config)) {
            map.put("auto_bootstrap", this.config.getAutoBoostrap());
        } else {
            map.put("auto_bootstrap", false);
        }
        map.put("saved_caches_directory", this.config.getCacheLocation());
        map.put("commitlog_directory", this.config.getCommitLogLocation());
        map.put("hints_directory", this.config.getHintsLocation());
        map.put("data_file_directories", Lists.newArrayList((Object[])new String[]{this.config.getDataFileLocation()}));
        boolean enableIncremental = SnapshotBackup.isBackupEnabled(this.config) && this.config.isIncrBackup() && (CollectionUtils.isEmpty(this.config.getBackupRacs()) || this.config.getBackupRacs().contains(this.config.getRac()));
        map.put("incremental_backups", enableIncremental);
        map.put("endpoint_snitch", this.config.getSnitch());
        if (map.containsKey("in_memory_compaction_limit_in_mb")) {
            map.remove("in_memory_compaction_limit_in_mb");
        }
        map.put("compaction_throughput_mb_per_sec", this.config.getCompactionThroughput());
        map.put("partitioner", this.derivePartitioner(map.get("partitioner").toString(), this.config.getPartitioner()));
        if (map.containsKey("memtable_total_space_in_mb")) {
            map.remove("memtable_total_space_in_mb");
        }
        map.put("stream_throughput_outbound_megabits_per_sec", this.config.getStreamingThroughputMB());
        if (map.containsKey("multithreaded_compaction")) {
            map.remove("multithreaded_compaction");
        }
        map.put("max_hint_window_in_ms", this.config.getMaxHintWindowInMS());
        map.put("hinted_handoff_throttle_in_kb", this.config.getHintedHandoffThrottleKb());
        map.put("authenticator", this.config.getAuthenticator());
        map.put("authorizer", this.config.getAuthorizer());
        map.put("internode_compression", this.config.getInternodeCompression());
        map.put("dynamic_snitch", this.config.isDynamicSnitchEnabled());
        map.put("concurrent_reads", this.config.getConcurrentReadsCnt());
        map.put("concurrent_writes", this.config.getConcurrentWritesCnt());
        map.put("concurrent_compactors", this.config.getConcurrentCompactorsCnt());
        map.put("broadcast_rpc_address", this.config.getInstanceDataRetriever().getPrivateIP());
        map.put("tombstone_warn_threshold", this.config.getTombstoneWarnThreshold());
        map.put("tombstone_failure_threshold", this.config.getTombstoneFailureThreshold());
        map.put("streaming_socket_timeout_in_ms", this.config.getStreamingSocketTimeoutInMS());
        map.put("memtable_cleanup_threshold", this.config.getMemtableCleanupThreshold());
        map.put("compaction_large_partition_warning_threshold_mb", this.config.getCompactionLargePartitionWarnThresholdInMB());
        List seedp = (List)map.get("seed_provider");
        Map m = (Map)seedp.get(0);
        m.put("class_name", seedProvider);
        this.configfureSecurity(map);
        this.configureGlobalCaches(this.config, map);
        map.put("num_tokens", 1);
        this.addExtraCassParams(map);
        map.remove("flush_largest_memtables_at");
        map.remove("reduce_cache_capacity_to");
        logger.info(yaml.dump((Object)map));
        yaml.dump((Object)map, (Writer)new FileWriter(yamlFile));
        this.configureCommitLogBackups();
        File configurationDirectory = new File(this.config.getCassConfigurationDirectory());
        if (configurationDirectory.exists() && configurationDirectory.isDirectory()) {
            String[] tunablePropertyFiles;
            for (String file : tunablePropertyFiles = this.config.getTunablePropertyFiles().split(",")) {
                String[] propertiesFile = file.split("\\.");
                if (propertiesFile.length <= 1 || propertiesFile[0].isEmpty()) continue;
                String prefix = propertiesFile[0];
                PropertiesFileTuner propertyTuner = new PropertiesFileTuner(this.config, prefix);
                propertyTuner.updateAndSaveProperties(Paths.get(configurationDirectory.getPath(), file).toString());
            }
        }
    }

    protected String getSnitch() {
        return this.config.getSnitch();
    }

    private void configureGlobalCaches(IConfiguration config, Map yaml) {
        String rowCacheSize;
        String keyCacheSize = config.getKeyCacheSizeInMB();
        if (keyCacheSize != null) {
            yaml.put("key_cache_size_in_mb", Integer.valueOf(keyCacheSize));
            String keyCount = config.getKeyCacheKeysToSave();
            if (keyCount != null) {
                yaml.put("key_cache_keys_to_save", Integer.valueOf(keyCount));
            }
        }
        if ((rowCacheSize = config.getRowCacheSizeInMB()) != null) {
            yaml.put("row_cache_size_in_mb", Integer.valueOf(rowCacheSize));
            String rowCount = config.getRowCacheKeysToSave();
            if (rowCount != null) {
                yaml.put("row_cache_keys_to_save", Integer.valueOf(rowCount));
            }
        }
    }

    String derivePartitioner(String fromYaml, String fromConfig) {
        if (fromYaml == null || fromYaml.isEmpty()) {
            return fromConfig;
        }
        String lowerCase = fromYaml.toLowerCase();
        if (lowerCase.contains("randomparti") || lowerCase.contains("murmur")) {
            return fromConfig;
        }
        return fromYaml;
    }

    protected void configfureSecurity(Map map) {
        Map clientEnc = (Map)map.get("client_encryption_options");
        clientEnc.put("enabled", this.config.isClientSslEnabled());
        Map serverEnc = (Map)map.get("server_encryption_options");
        serverEnc.put("internode_encryption", this.config.getInternodeEncryption());
    }

    protected void configureCommitLogBackups() throws IOException {
        if (!this.config.isBackingUpCommitLogs()) {
            return;
        }
        Properties props = new Properties();
        props.put("archive_command", this.config.getCommitLogBackupArchiveCmd());
        props.put("restore_command", this.config.getCommitLogBackupRestoreCmd());
        props.put("restore_directories", this.config.getCommitLogBackupRestoreFromDirs());
        props.put("restore_point_in_time", this.config.getCommitLogBackupRestorePointInTime());
        try (FileOutputStream fos = new FileOutputStream(new File(this.config.getCommitLogBackupPropsFile()));){
            props.store(fos, "cassandra commit log archive props, as written by priam");
        }
        catch (IOException e) {
            logger.error("Could not store commitlog_archiving.properties", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateAutoBootstrap(String yamlFile, boolean autobootstrap) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        Map map = (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
        map.put("auto_bootstrap", autobootstrap);
        if (logger.isInfoEnabled()) {
            logger.info("Updating yaml: " + yaml.dump((Object)map));
        }
        yaml.dump((Object)map, (Writer)new FileWriter(yamlFile));
    }

    @Override
    public final void updateJVMOptions() throws Exception {
        JVMOptionsTuner tuner = new JVMOptionsTuner(this.config);
        tuner.updateAndSaveJVMOptions(this.config.getJVMOptionsFileLocation());
    }

    public void addExtraCassParams(Map map) {
        String params = this.config.getExtraConfigParams();
        if (params == null) {
            logger.info("Updating yaml: no extra cass params");
            return;
        }
        String[] pairs = params.split(",");
        logger.info("Updating yaml: adding extra cass params");
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i].split("=");
            String priamKey = pair[0];
            String cassKey = pair[1];
            String cassVal = this.config.getCassYamlVal(priamKey);
            logger.info("Updating yaml: Priamkey[{}], CassKey[{}], Val[{}]", new Object[]{priamKey, cassKey, cassVal});
            map.put(cassKey, cassVal);
        }
    }
}

