/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner.dse;

import com.google.inject.Inject;
import com.netflix.priam.tuner.dse.IAuditLogTuner;
import com.netflix.priam.tuner.dse.IDseConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AuditLogTunerYaml
implements IAuditLogTuner {
    private IDseConfiguration dseConfig;
    private static final String AUDIT_LOG_DSE_ENTRY = "audit_logging_options";
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTunerYaml.class);

    @Inject
    public AuditLogTunerYaml(IDseConfiguration dseConfig) {
        this.dseConfig = dseConfig;
    }

    @Override
    public void tuneAuditLog() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        String dseYaml = this.dseConfig.getDseYamlLocation();
        try {
            Map map = (Map)yaml.load((InputStream)new FileInputStream(dseYaml));
            if (map.containsKey(AUDIT_LOG_DSE_ENTRY)) {
                Boolean isEnabled = (Boolean)((Map)map.get(AUDIT_LOG_DSE_ENTRY)).get("enabled");
                if (this.dseConfig.isAuditLogEnabled()) {
                    if (!isEnabled.booleanValue()) {
                        ((Map)map.get(AUDIT_LOG_DSE_ENTRY)).put("enabled", true);
                    }
                } else if (isEnabled.booleanValue()) {
                    ((Map)map.get(AUDIT_LOG_DSE_ENTRY)).put("enabled", false);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Updating dse-yaml:\n" + yaml.dump((Object)map));
            }
            yaml.dump((Object)map, (Writer)new FileWriter(dseYaml));
        }
        catch (FileNotFoundException fileNotFound) {
            logger.error("FileNotFound while trying to read yaml audit log for tuning: {}", (Object)dseYaml);
        }
        catch (IOException e) {
            logger.error("IOException while trying to write yaml file for audit log tuning: {}", (Object)dseYaml);
        }
    }
}

