/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.ThreadSleeper;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoundedExponentialRetryCallable<T>
extends RetryableCallable<T> {
    private static final long MAX_SLEEP = 10000L;
    private static final long MIN_SLEEP = 1000L;
    private static final int MAX_RETRIES = 10;
    private static final Logger logger = LoggerFactory.getLogger(BoundedExponentialRetryCallable.class);
    private long max;
    private long min;
    private int maxRetries;
    private final ThreadSleeper sleeper = new ThreadSleeper();

    public BoundedExponentialRetryCallable() {
        this.max = 10000L;
        this.min = 1000L;
        this.maxRetries = 10;
    }

    public BoundedExponentialRetryCallable(long minSleep, long maxSleep, int maxNumRetries) {
        this.max = maxSleep;
        this.min = minSleep;
        this.maxRetries = maxNumRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        long delay = this.min;
        int retry = 0;
        int logCounter = 0;
        while (true) {
            try {
                Object t = this.retriableCall();
                return t;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (delay < this.max && ++retry <= this.maxRetries) {
                    delay *= 2L;
                    logger.error("Retry #{} for: {}", (Object)retry, (Object)e.getMessage());
                    if (++logCounter == 1 && logger.isInfoEnabled()) {
                        logger.info("Exception --> " + ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    this.sleeper.sleep(delay);
                    continue;
                }
                if (delay >= this.max && retry <= this.maxRetries) {
                    if (logger.isErrorEnabled()) {
                        logger.error(String.format("Retry #%d for: %s", retry, ExceptionUtils.getStackTrace((Throwable)e)));
                    }
                    this.sleeper.sleep(this.max);
                    continue;
                }
                throw e;
            }
            finally {
                this.forEachExecution();
                continue;
            }
            break;
        }
    }
}

