/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.netflix.priam.utils.DateUtil;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Date;

public class GsonJsonSerializer {
    private static final Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter()).registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter()).registerTypeAdapter(Path.class, (Object)new PathTypeAdapter()).setExclusionStrategies(new ExclusionStrategy[]{new PriamAnnotationExclusionStrategy()}).create();

    public static Gson getGson() {
        return gson;
    }

    static class PathTypeAdapter
    extends TypeAdapter<Path> {
        PathTypeAdapter() {
        }

        public void write(JsonWriter out, Path value) throws IOException {
            String fileName = value != null ? value.toFile().getName() : null;
            out.value(fileName);
        }

        public Path read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String result = in.nextString();
            if ("".equals(result)) {
                return null;
            }
            return Paths.get(result, new String[0]);
        }
    }

    static class InstantTypeAdapter
    extends TypeAdapter<Instant> {
        InstantTypeAdapter() {
        }

        public void write(JsonWriter out, Instant value) throws IOException {
            out.value(this.getEpoch(value));
        }

        private long getEpoch(Instant value) {
            return value == null ? null : Long.valueOf(value.toEpochMilli());
        }

        public Instant read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String result = in.nextString();
            if ("".equals(result)) {
                return null;
            }
            return Instant.ofEpochMilli(Long.parseLong(result));
        }
    }

    static class LocalDateTimeTypeAdapter
    extends TypeAdapter<LocalDateTime> {
        LocalDateTimeTypeAdapter() {
        }

        public void write(JsonWriter out, LocalDateTime value) throws IOException {
            out.value(DateUtil.formatyyyyMMddHHmm(value));
        }

        public LocalDateTime read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String result = in.nextString();
            if ("".equals(result)) {
                return null;
            }
            return DateUtil.getLocalDateTime(result);
        }
    }

    static class DateTypeAdapter
    extends TypeAdapter<Date> {
        DateTypeAdapter() {
        }

        public void write(JsonWriter out, Date value) throws IOException {
            out.value(DateUtil.formatyyyyMMddHHmm(value));
        }

        public Date read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String result = in.nextString();
            if ("".equals(result)) {
                return null;
            }
            return DateUtil.getDate(result);
        }
    }

    public static class PriamAnnotation {

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface GsonIgnore {
        }
    }

    public static class PriamAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.getAnnotation(PriamAnnotation.GsonIgnore.class) != null;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(PriamAnnotation.GsonIgnore.class) != null;
        }
    }
}

