/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.utils.BoundedExponentialRetryCallable;
import com.netflix.priam.utils.CassandraMonitor;
import com.netflix.priam.utils.INodeToolObservable;
import com.netflix.priam.utils.INodeToolObserver;
import com.netflix.priam.utils.JMXConnectionException;
import com.netflix.priam.utils.SystemUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JMXNodeTool
extends NodeProbe
implements INodeToolObservable {
    private static final Logger logger = LoggerFactory.getLogger(JMXNodeTool.class);
    private static volatile JMXNodeTool tool = null;
    private MBeanServerConnection mbeanServerConn = null;
    private static Set<INodeToolObserver> observers = new HashSet<INodeToolObserver>();

    public JMXNodeTool(String host, int port) throws IOException, InterruptedException {
        super(host, port);
    }

    public JMXNodeTool(String host, int port, String username, String password) throws IOException, InterruptedException {
        super(host, port, username, password);
    }

    @Inject
    public JMXNodeTool(IConfiguration config) throws IOException, InterruptedException {
        super("localhost", config.getJmxPort());
    }

    public static JMXNodeTool instance(IConfiguration config) throws JMXConnectionException {
        if (!JMXNodeTool.testConnection()) {
            tool = JMXNodeTool.connect(config);
        }
        return tool;
    }

    public static <T> T getRemoteBean(Class<T> clazz, String mbeanName, IConfiguration config, boolean mxbean) throws IOException, MalformedObjectNameException {
        if (mxbean) {
            return ManagementFactory.newPlatformMXBeanProxy(JMXNodeTool.instance((IConfiguration)config).mbeanServerConn, mbeanName, clazz);
        }
        return JMX.newMBeanProxy(JMXNodeTool.instance((IConfiguration)config).mbeanServerConn, new ObjectName(mbeanName), clazz);
    }

    private static boolean testConnection() {
        if (tool == null) {
            return false;
        }
        try {
            MBeanServerConnection serverConn = JMXNodeTool.tool.mbeanServerConn;
            if (serverConn == null) {
                logger.info("Test connection to remove MBean server failed as there is no connection.");
                return false;
            }
            if (serverConn.getMBeanCount() < 1) {
                logger.info("Test connection to remove MBean server failed as there is no registered MBeans.");
                return false;
            }
        }
        catch (Throwable ex) {
            SystemUtils.closeQuietly(tool);
            logger.error("Exception while checking JMX connection to C*, msg: {}", (Object)ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public static synchronized JMXNodeTool createNewConnection(IConfiguration config) throws JMXConnectionException {
        return JMXNodeTool.createConnection(config);
    }

    public static synchronized JMXNodeTool connect(IConfiguration config) throws JMXConnectionException {
        if (!JMXNodeTool.testConnection()) {
            if (tool != null) {
                try {
                    tool.close();
                }
                catch (IOException e) {
                    logger.warn("Exception performing house cleaning -- closing current connection to jmx remote agent.  Msg: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
        } else {
            return tool;
        }
        return JMXNodeTool.createConnection(config);
    }

    private static JMXNodeTool createConnection(final IConfiguration config) throws JMXConnectionException {
        if (!CassandraMonitor.hasCassadraStarted().booleanValue()) {
            String exceptionMsg = "Cannot perform connection to remove jmx agent as Cassandra has not yet started, check back again later";
            logger.debug(exceptionMsg);
            throw new JMXConnectionException(exceptionMsg);
        }
        if (tool != null) {
            try {
                tool.close();
            }
            catch (IOException e) {
                logger.warn("Exception performing house cleaning -- closing current connection to jmx remote agent.  Msg: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        try {
            tool = (JMXNodeTool)new BoundedExponentialRetryCallable<JMXNodeTool>(){

                @Override
                public JMXNodeTool retriableCall() throws Exception {
                    JMXNodeTool nodetool = !(config.getJmxUsername() != null && !config.getJmxUsername().isEmpty() || config.getJmxPassword() != null && !config.getJmxPassword().isEmpty()) ? new JMXNodeTool("localhost", config.getJmxPort()) : new JMXNodeTool("localhost", config.getJmxPort(), config.getJmxUsername(), config.getJmxPassword());
                    Field[] fields = NodeProbe.class.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        if (!fields[i].getName().equals("mbeanServerConn")) continue;
                        fields[i].setAccessible(true);
                        nodetool.mbeanServerConn = (MBeanServerConnection)fields[i].get(nodetool);
                    }
                    return nodetool;
                }
            }.call();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new JMXConnectionException(e.getMessage());
        }
        logger.info("Connected to remote jmx agent, will notify interested parties!");
        for (INodeToolObserver observer : observers) {
            observer.nodeToolHasChanged(tool);
        }
        return tool;
    }

    public JSONObject estimateKeys() throws JSONException {
        Iterator it = super.getColumnFamilyStoreMBeanProxies();
        JSONObject object = new JSONObject();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            object.put("keyspace", entry.getKey());
            object.put("column_family", (Object)((ColumnFamilyStoreMBean)entry.getValue()).getColumnFamilyName());
            object.put("estimated_size", ((ColumnFamilyStoreMBean)entry.getValue()).estimateKeys());
        }
        return object;
    }

    public JSONObject info() throws JSONException {
        JSONObject object = new JSONObject();
        object.put("gossip_active", this.isInitialized());
        object.put("token", (Object)this.getTokens().toString());
        object.put("load", (Object)this.getLoadString());
        object.put("generation_no", this.getCurrentGenerationNumber());
        object.put("uptime", this.getUptime() / 1000L);
        MemoryUsage heapUsage = this.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        object.put("heap_memory_mb", (Object)(memUsed + "/" + memMax));
        object.put("data_center", (Object)this.getDataCenter());
        object.put("rack", (Object)this.getRack());
        return object;
    }

    public JSONArray ring(String keyspace) throws JSONException {
        Map ownerships;
        JSONArray ring = new JSONArray();
        Map tokenToEndpoint = this.getTokenToEndpointMap(false);
        ArrayList sortedTokens = new ArrayList(tokenToEndpoint.keySet());
        List liveNodes = this.getLiveNodes(false);
        List deadNodes = this.getUnreachableNodes(false);
        List joiningNodes = this.getJoiningNodes(false);
        List leavingNodes = this.getLeavingNodes(false);
        List movingNodes = this.getMovingNodes(false);
        Map loadMap = this.getLoadMap(false);
        String format = "%-16s%-12s%-12s%-7s%-8s%-16s%-20s%-44s%n";
        try {
            ownerships = this.effectiveOwnership(keyspace);
        }
        catch (IllegalStateException ex) {
            ownerships = this.getOwnership();
        }
        for (String token : sortedTokens) {
            String rack;
            String dataCenter;
            String primaryEndpoint = (String)tokenToEndpoint.get(token);
            try {
                dataCenter = this.getEndpointSnitchInfoProxy().getDatacenter(primaryEndpoint);
            }
            catch (UnknownHostException e) {
                dataCenter = "Unknown";
            }
            try {
                rack = this.getEndpointSnitchInfoProxy().getRack(primaryEndpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(primaryEndpoint) ? "Up" : (deadNodes.contains(primaryEndpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(primaryEndpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(primaryEndpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(primaryEndpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(primaryEndpoint) ? (String)loadMap.get(primaryEndpoint) : "?";
            String owns = new DecimalFormat("##0.00%").format(ownerships.get(token) == null ? 0.0 : (double)((Float)ownerships.get(token)).floatValue());
            ring.put((Object)this.createJson(primaryEndpoint, dataCenter, rack, status, state, load, owns, token));
        }
        return ring;
    }

    private JSONObject createJson(String primaryEndpoint, String dataCenter, String rack, String status, String state, String load, String owns, String token) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("endpoint", (Object)primaryEndpoint);
        object.put("dc", (Object)dataCenter);
        object.put("rack", (Object)rack);
        object.put("status", (Object)status);
        object.put("state", (Object)state);
        object.put("load", (Object)load);
        object.put("owns", (Object)owns);
        object.put("token", (Object)token);
        return object;
    }

    public void repair(boolean isSequential, boolean localDataCenterOnly) throws IOException, ExecutionException, InterruptedException {
        this.repair(isSequential, localDataCenterOnly, false);
    }

    public void repair(boolean isSequential, boolean localDataCenterOnly, boolean primaryRange) throws IOException, ExecutionException, InterruptedException {
        HashMap<String, String> repairOptions = new HashMap<String, String>();
        repairOptions.put("parallelism", Boolean.toString(!isSequential));
        repairOptions.put("primaryRange", Boolean.toString(primaryRange));
        if (localDataCenterOnly) {
            repairOptions.put("dataCenters", this.getDataCenter());
        }
        PrintStream printStream = new PrintStream("repair.log");
        for (String keyspace : this.getKeyspaces()) {
            this.repairAsync(printStream, keyspace, repairOptions);
        }
    }

    public void cleanup() throws IOException, ExecutionException, InterruptedException {
        for (String keyspace : this.getKeyspaces()) {
            this.forceKeyspaceCleanup(0, keyspace, new String[0]);
        }
    }

    public void refresh(List<String> keyspaces) throws IOException, ExecutionException, InterruptedException {
        Iterator it = super.getColumnFamilyStoreMBeanProxies();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!keyspaces.contains(entry.getKey())) continue;
            logger.info("Refreshing {} {}", entry.getKey(), (Object)((ColumnFamilyStoreMBean)entry.getValue()).getColumnFamilyName());
            this.loadNewSSTables((String)entry.getKey(), ((ColumnFamilyStoreMBean)entry.getValue()).getColumnFamilyName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Class<JMXNodeTool> clazz = JMXNodeTool.class;
        synchronized (JMXNodeTool.class) {
            tool = null;
            super.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(INodeToolObserver observer) {
        if (observer == null) {
            throw new NullPointerException("Cannot not observer.");
        }
        Set<INodeToolObserver> set = observers;
        synchronized (set) {
            observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObserver(INodeToolObserver observer) {
        Set<INodeToolObserver> set = observers;
        synchronized (set) {
            observers.remove(observer);
        }
    }
}

