/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredential;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.InstanceEnvIdentity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSMembership
implements IMembership {
    private static final Logger logger = LoggerFactory.getLogger(AWSMembership.class);
    private final IConfiguration config;
    private final ICredential provider;
    private final InstanceEnvIdentity insEnvIdentity;
    private final ICredential crossAccountProvider;

    @Inject
    public AWSMembership(IConfiguration config, ICredential provider, @Named(value="awsec2roleassumption") ICredential crossAccountProvider, InstanceEnvIdentity insEnvIdentity) {
        this.config = config;
        this.provider = provider;
        this.insEnvIdentity = insEnvIdentity;
        this.crossAccountProvider = crossAccountProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRacMembership() {
        AmazonAutoScaling client = null;
        try {
            ArrayList<String> asgNames = new ArrayList<String>();
            asgNames.add(this.config.getASGName());
            asgNames.addAll(Arrays.asList(this.config.getSiblingASGNames().split("\\s*,\\s*")));
            client = this.getAutoScalingClient();
            DescribeAutoScalingGroupsRequest asgReq = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(asgNames.toArray(new String[asgNames.size()]));
            DescribeAutoScalingGroupsResult res = client.describeAutoScalingGroups(asgReq);
            ArrayList instanceIds = Lists.newArrayList();
            for (AutoScalingGroup asg : res.getAutoScalingGroups()) {
                for (Instance ins : asg.getInstances()) {
                    if (ins.getLifecycleState().equalsIgnoreCase("Terminating") || ins.getLifecycleState().equalsIgnoreCase("shutting-down") || ins.getLifecycleState().equalsIgnoreCase("Terminated")) continue;
                    instanceIds.add(ins.getInstanceId());
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Querying Amazon returned following instance in the RAC: %s, ASGs: %s --> %s", this.config.getRac(), StringUtils.join(asgNames, (String)","), StringUtils.join((Iterable)instanceIds, (String)",")));
            }
            ArrayList arrayList = instanceIds;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRacMembershipSize() {
        AmazonAutoScaling client = null;
        try {
            client = this.getAutoScalingClient();
            DescribeAutoScalingGroupsRequest asgReq = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{this.config.getASGName()});
            DescribeAutoScalingGroupsResult res = client.describeAutoScalingGroups(asgReq);
            int size = 0;
            for (AutoScalingGroup asg : res.getAutoScalingGroups()) {
                size += asg.getMaxSize().intValue();
            }
            logger.info("Query on ASG returning {} instances", (Object)size);
            int n = size;
            return n;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCrossAccountRacMembership() {
        AmazonAutoScaling client = null;
        try {
            ArrayList<String> asgNames = new ArrayList<String>();
            asgNames.add(this.config.getASGName());
            asgNames.addAll(Arrays.asList(this.config.getSiblingASGNames().split("\\s*,\\s*")));
            client = this.getCrossAccountAutoScalingClient();
            DescribeAutoScalingGroupsRequest asgReq = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(asgNames.toArray(new String[asgNames.size()]));
            DescribeAutoScalingGroupsResult res = client.describeAutoScalingGroups(asgReq);
            ArrayList instanceIds = Lists.newArrayList();
            for (AutoScalingGroup asg : res.getAutoScalingGroups()) {
                for (Instance ins : asg.getInstances()) {
                    if (ins.getLifecycleState().equalsIgnoreCase("Terminating") || ins.getLifecycleState().equalsIgnoreCase("shutting-down") || ins.getLifecycleState().equalsIgnoreCase("Terminated")) continue;
                    instanceIds.add(ins.getInstanceId());
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Querying Amazon returned following instance in the cross-account ASG: %s --> %s", this.config.getRac(), StringUtils.join((Iterable)instanceIds, (String)",")));
            }
            ArrayList arrayList = instanceIds;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    @Override
    public int getRacCount() {
        return this.config.getRacs().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addACL(Collection<String> listIPs, int from, int to) {
        AmazonEC2 client = null;
        try {
            client = this.getEc2Client();
            ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
            ipPermissions.add(new IpPermission().withFromPort(Integer.valueOf(from)).withIpProtocol("tcp").withIpRanges(listIPs).withToPort(Integer.valueOf(to)));
            if (this.insEnvIdentity.isClassic().booleanValue()) {
                client.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest(this.config.getACLGroupName(), ipPermissions));
                if (logger.isInfoEnabled()) {
                    logger.info("Done adding ACL to classic: " + StringUtils.join(listIPs, (String)","));
                }
            } else {
                AuthorizeSecurityGroupIngressRequest sgIngressRequest = new AuthorizeSecurityGroupIngressRequest();
                sgIngressRequest.withGroupId(this.getVpcGoupId());
                client.authorizeSecurityGroupIngress(sgIngressRequest.withIpPermissions(ipPermissions));
                if (logger.isInfoEnabled()) {
                    logger.info("Done adding ACL to vpc: " + StringUtils.join(listIPs, (String)","));
                }
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getVpcGoupId() {
        AmazonEC2 client = null;
        try {
            client = this.getEc2Client();
            Filter nameFilter = new Filter().withName("group-name").withValues(new String[]{this.config.getACLGroupName()});
            Filter vpcFilter = new Filter().withName("vpc-id").withValues(new String[]{this.config.getVpcId()});
            DescribeSecurityGroupsRequest req = new DescribeSecurityGroupsRequest().withFilters(new Filter[]{nameFilter, vpcFilter});
            DescribeSecurityGroupsResult result = client.describeSecurityGroups(req);
            Object object = result.getSecurityGroups().iterator();
            if (object.hasNext()) {
                SecurityGroup group = (SecurityGroup)object.next();
                logger.debug("got group-id:{} for group-name:{},vpc-id:{}", new Object[]{group.getGroupId(), this.config.getACLGroupName(), this.config.getVpcId()});
                String string = group.getGroupId();
                return string;
            }
            logger.error("unable to get group-id for group-name={} vpc-id={}", (Object)this.config.getACLGroupName(), (Object)this.config.getVpcId());
            object = "";
            return object;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeACL(Collection<String> listIPs, int from, int to) {
        AmazonEC2 client = null;
        try {
            client = this.getEc2Client();
            ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
            ipPermissions.add(new IpPermission().withFromPort(Integer.valueOf(from)).withIpProtocol("tcp").withIpRanges(listIPs).withToPort(Integer.valueOf(to)));
            if (this.insEnvIdentity.isClassic().booleanValue()) {
                client.revokeSecurityGroupIngress(new RevokeSecurityGroupIngressRequest(this.config.getACLGroupName(), ipPermissions));
                if (logger.isInfoEnabled()) {
                    logger.info("Done removing from ACL within classic env for running instance: " + StringUtils.join(listIPs, (String)","));
                }
            } else {
                RevokeSecurityGroupIngressRequest req = new RevokeSecurityGroupIngressRequest();
                req.withGroupId(this.getVpcGoupId());
                client.revokeSecurityGroupIngress(req.withIpPermissions(ipPermissions));
                if (logger.isInfoEnabled()) {
                    logger.info("Done removing from ACL within vpc env for running instance: " + StringUtils.join(listIPs, (String)","));
                }
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listACL(int from, int to) {
        AmazonEC2 client = null;
        try {
            client = this.getEc2Client();
            ArrayList<String> ipPermissions = new ArrayList<String>();
            if (this.insEnvIdentity.isClassic().booleanValue()) {
                DescribeSecurityGroupsRequest req = new DescribeSecurityGroupsRequest().withGroupNames(Arrays.asList(this.config.getACLGroupName()));
                DescribeSecurityGroupsResult result = client.describeSecurityGroups(req);
                for (SecurityGroup group : result.getSecurityGroups()) {
                    for (IpPermission perm : group.getIpPermissions()) {
                        if (perm.getFromPort() != from || perm.getToPort() != to) continue;
                        ipPermissions.addAll(perm.getIpRanges());
                    }
                }
                logger.debug("Fetch current permissions for classic env of running instance");
            } else {
                Filter nameFilter = new Filter().withName("group-name").withValues(new String[]{this.config.getACLGroupName()});
                String vpcid = this.config.getVpcId();
                if (vpcid == null || vpcid.isEmpty()) {
                    throw new IllegalStateException("vpcid is null even though instance is running in vpc.");
                }
                Filter vpcFilter = new Filter().withName("vpc-id").withValues(new String[]{vpcid});
                DescribeSecurityGroupsRequest req = new DescribeSecurityGroupsRequest().withFilters(new Filter[]{nameFilter, vpcFilter});
                DescribeSecurityGroupsResult result = client.describeSecurityGroups(req);
                for (SecurityGroup group : result.getSecurityGroups()) {
                    for (IpPermission perm : group.getIpPermissions()) {
                        if (perm.getFromPort() != from || perm.getToPort() != to) continue;
                        ipPermissions.addAll(perm.getIpRanges());
                    }
                }
                logger.debug("Fetch current permissions for vpc env of running instance");
            }
            ArrayList<String> arrayList = ipPermissions;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expandRacMembership(int count) {
        AmazonAutoScaling client = null;
        try {
            client = this.getAutoScalingClient();
            DescribeAutoScalingGroupsRequest asgReq = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{this.config.getASGName()});
            DescribeAutoScalingGroupsResult res = client.describeAutoScalingGroups(asgReq);
            AutoScalingGroup asg = (AutoScalingGroup)res.getAutoScalingGroups().get(0);
            UpdateAutoScalingGroupRequest ureq = new UpdateAutoScalingGroupRequest();
            ureq.setAutoScalingGroupName(asg.getAutoScalingGroupName());
            ureq.setMinSize(Integer.valueOf(asg.getMinSize() + 1));
            ureq.setMaxSize(Integer.valueOf(asg.getMinSize() + 1));
            ureq.setDesiredCapacity(Integer.valueOf(asg.getMinSize() + 1));
            client.updateAutoScalingGroup(ureq);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    protected AmazonAutoScaling getAutoScalingClient() {
        AmazonAutoScalingClient client = new AmazonAutoScalingClient(this.provider.getAwsCredentialProvider());
        client.setEndpoint("autoscaling." + this.config.getDC() + ".amazonaws.com");
        return client;
    }

    protected AmazonAutoScaling getCrossAccountAutoScalingClient() {
        AmazonAutoScalingClient client = new AmazonAutoScalingClient(this.crossAccountProvider.getAwsCredentialProvider());
        client.setEndpoint("autoscaling." + this.config.getDC() + ".amazonaws.com");
        return client;
    }

    protected AmazonEC2 getEc2Client() {
        AmazonEC2Client client = new AmazonEC2Client(this.provider.getAwsCredentialProvider());
        client.setEndpoint("ec2." + this.config.getDC() + ".amazonaws.com");
        return client;
    }
}

