/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws.auth;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredential;
import com.netflix.priam.identity.InstanceEnvIdentity;

public class EC2RoleAssumptionCredential
implements ICredential {
    private static final String AWS_ROLE_ASSUMPTION_SESSION_NAME = "AwsRoleAssumptionSession";
    private ICredential cred;
    private IConfiguration config;
    private InstanceEnvIdentity insEnvIdentity;
    private AWSCredentialsProvider stsSessionCredentialsProvider;

    @Inject
    public EC2RoleAssumptionCredential(ICredential cred, IConfiguration config, InstanceEnvIdentity insEnvIdentity) {
        this.cred = cred;
        this.config = config;
        this.insEnvIdentity = insEnvIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentialsProvider getAwsCredentialProvider() {
        if (this.config.isDualAccount() || this.stsSessionCredentialsProvider == null) {
            EC2RoleAssumptionCredential eC2RoleAssumptionCredential = this;
            synchronized (eC2RoleAssumptionCredential) {
                if (this.stsSessionCredentialsProvider == null) {
                    String roleArn = null;
                    roleArn = this.insEnvIdentity.isClassic() != false ? this.config.getClassicEC2RoleAssumptionArn() : this.config.getVpcEC2RoleAssumptionArn();
                    if (roleArn == null || roleArn.isEmpty()) {
                        throw new NullPointerException("Role ARN is null or empty probably due to missing config entry");
                    }
                    try {
                        this.stsSessionCredentialsProvider = new STSAssumeRoleSessionCredentialsProvider(this.cred.getAwsCredentialProvider(), roleArn, AWS_ROLE_ASSUMPTION_SESSION_NAME);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Exception in getting handle to AWS Security Token Service (STS).  Msg: " + ex.getLocalizedMessage(), ex);
                    }
                }
            }
        }
        return this.stsSessionCredentialsProvider;
    }
}

