/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.aws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.aws.auth.IS3Credential;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3RoleAssumptionCredential
implements IS3Credential {
    private static final String AWS_ROLE_ASSUMPTION_SESSION_NAME = "S3RoleAssumptionSession";
    private static final Logger logger = LoggerFactory.getLogger(S3RoleAssumptionCredential.class);
    private ICredential cred;
    private IConfiguration config;
    private AWSCredentialsProvider stsSessionCredentialsProvider;

    @Inject
    public S3RoleAssumptionCredential(ICredential cred, IConfiguration config) {
        this.cred = cred;
        this.config = config;
    }

    @Override
    public AWSCredentials getCredentials() throws Exception {
        if (this.stsSessionCredentialsProvider == null) {
            this.getAwsCredentialProvider();
        }
        return this.stsSessionCredentialsProvider.getCredentials();
    }

    public void refresh() {
        this.cred.getAwsCredentialProvider().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentialsProvider getAwsCredentialProvider() {
        if (this.stsSessionCredentialsProvider == null) {
            S3RoleAssumptionCredential s3RoleAssumptionCredential = this;
            synchronized (s3RoleAssumptionCredential) {
                if (this.stsSessionCredentialsProvider == null) {
                    String roleArn = this.config.getAWSRoleAssumptionArn();
                    if (roleArn == null || roleArn.isEmpty()) {
                        logger.warn("Role ARN is null or empty probably due to missing config entry. Falling back to instance level credentials");
                        this.stsSessionCredentialsProvider = this.cred.getAwsCredentialProvider();
                    } else {
                        try {
                            this.stsSessionCredentialsProvider = new STSAssumeRoleSessionCredentialsProvider(this.cred.getAwsCredentialProvider(), roleArn, AWS_ROLE_ASSUMPTION_SESSION_NAME);
                        }
                        catch (Exception ex) {
                            throw new IllegalStateException("Exception in getting handle to AWS Security Token Service (STS).  Msg: " + ex.getLocalizedMessage(), ex);
                        }
                    }
                }
            }
        }
        return this.stsSessionCredentialsProvider;
    }
}

