/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreUtil;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackup
extends Task {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBackup.class);
    public static final String INCREMENTAL_BACKUP_FOLDER = "backups";
    public static final String SNAPSHOT_FOLDER = "snapshots";
    protected final Provider<AbstractBackupPath> pathFactory;
    protected IBackupFileSystem fs;

    @Inject
    public AbstractBackup(IConfiguration config, IFileSystemContext backupFileSystemCtx, Provider<AbstractBackupPath> pathFactory) {
        super(config);
        this.pathFactory = pathFactory;
        this.fs = backupFileSystemCtx.getFileStrategy(config);
    }

    protected void setFileSystem(IBackupFileSystem fs) {
        this.fs = fs;
    }

    List<AbstractBackupPath> upload(File parent, AbstractBackupPath.BackupFileType type) throws Exception {
        ArrayList bps = Lists.newArrayList();
        for (final File file : parent.listFiles()) {
            final AbstractBackupPath bp = (AbstractBackupPath)this.pathFactory.get();
            bp.parseLocal(file, type);
            try {
                logger.info("About to upload file {} for backup", (Object)file.getCanonicalFile());
                AbstractBackupPath abp = (AbstractBackupPath)new RetryableCallable<AbstractBackupPath>(3, 100L){

                    @Override
                    public AbstractBackupPath retriableCall() throws Exception {
                        AbstractBackup.this.upload(bp);
                        file.delete();
                        return bp;
                    }
                }.call();
                if (abp != null) {
                    bps.add(abp);
                }
                this.addToRemotePath(abp.getRemotePath());
            }
            catch (Exception e) {
                logger.error("Failed to upload local file {} within CF {}.", new Object[]{file.getCanonicalFile(), parent.getAbsolutePath(), e});
                throw e;
            }
        }
        return bps;
    }

    protected void upload(final AbstractBackupPath bp) throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                InputStream is = null;
                try {
                    is = bp.localReader();
                    if (is == null) {
                        throw new NullPointerException("Unable to get handle on file: " + bp.fileName);
                    }
                    AbstractBackup.this.fs.upload(bp, is);
                    bp.setCompressedFileSize(AbstractBackup.this.fs.getBytesUploaded());
                    return null;
                }
                catch (Exception e) {
                    logger.error("Exception uploading local file {},  releasing handle, and will retry.", (Object)bp.backupFile.getCanonicalFile());
                    if (is != null) {
                        is.close();
                    }
                    throw e;
                }
            }
        }.call();
    }

    protected final void initiateBackup(String monitoringFolder, BackupRestoreUtil backupRestoreUtil) throws Exception {
        File dataDir = new File(this.config.getDataFileLocation());
        if (!dataDir.exists()) {
            throw new IllegalArgumentException("The configured 'data file location' does not exist: " + this.config.getDataFileLocation());
        }
        logger.debug("Scanning for backup in: {}", (Object)dataDir.getAbsolutePath());
        for (File keyspaceDir : dataDir.listFiles()) {
            if (keyspaceDir.isFile()) continue;
            logger.debug("Entering {} keyspace..", (Object)keyspaceDir.getName());
            for (File columnFamilyDir : keyspaceDir.listFiles()) {
                File backupDir = new File(columnFamilyDir, monitoringFolder);
                if (!this.isValidBackupDir(keyspaceDir, backupDir)) continue;
                String columnFamilyName = columnFamilyDir.getName().split("-")[0];
                if (backupRestoreUtil.isFiltered(keyspaceDir.getName(), columnFamilyDir.getName())) {
                    SystemUtils.cleanupDir(backupDir.getAbsolutePath(), null);
                    continue;
                }
                this.processColumnFamily(keyspaceDir.getName(), columnFamilyName, backupDir);
            }
        }
    }

    protected abstract void processColumnFamily(String var1, String var2, File var3) throws Exception;

    private boolean isValidBackupDir(File keyspaceDir, File backupDir) {
        if (!backupDir.isDirectory() && !backupDir.exists()) {
            return false;
        }
        String keyspaceName = keyspaceDir.getName();
        if (BackupRestoreUtil.FILTER_KEYSPACE.contains(keyspaceName)) {
            logger.debug("{} is not consider a valid keyspace backup directory, will be bypass.", (Object)keyspaceName);
            return false;
        }
        return true;
    }

    protected abstract void addToRemotePath(String var1);
}

