/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.netflix.priam.backup.AbstractBackup;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreUtil;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.IIncrementalBackup;
import com.netflix.priam.backup.IMessageObserver;
import com.netflix.priam.backup.IncrementalMetaData;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.TaskTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IncrementalBackup
extends AbstractBackup
implements IIncrementalBackup {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalBackup.class);
    public static final String JOBNAME = "IncrementalBackup";
    private final List<String> incrementalRemotePaths = new ArrayList<String>();
    private IncrementalMetaData metaData;
    private BackupRestoreUtil backupRestoreUtil;
    private static List<IMessageObserver> observers = new ArrayList<IMessageObserver>();

    @Inject
    public IncrementalBackup(IConfiguration config, Provider<AbstractBackupPath> pathFactory, IFileSystemContext backupFileSystemCtx, IncrementalMetaData metaData) {
        super(config, backupFileSystemCtx, pathFactory);
        this.metaData = metaData;
        this.backupRestoreUtil = new BackupRestoreUtil(config.getIncrementalKeyspaceFilters(), config.getIncrementalCFFilter());
    }

    @Override
    public void execute() throws Exception {
        this.incrementalRemotePaths.clear();
        this.initiateBackup("backups", this.backupRestoreUtil);
        if (this.incrementalRemotePaths.size() > 0) {
            this.notifyObservers();
        }
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME, 10000L);
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static void addObserver(IMessageObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(IMessageObserver observer) {
        observers.remove(observer);
    }

    private void notifyObservers() {
        for (IMessageObserver observer : observers) {
            if (observer != null) {
                logger.debug("Updating incremental observers now ...");
                observer.update(IMessageObserver.BACKUP_MESSAGE_TYPE.INCREMENTAL, this.incrementalRemotePaths);
                continue;
            }
            logger.info("Observer is Null, hence can not notify ...");
        }
    }

    @Override
    protected void processColumnFamily(String keyspace, String columnFamily, File backupDir) throws Exception {
        List<AbstractBackupPath> uploadedFiles = this.upload(backupDir, AbstractBackupPath.BackupFileType.SST);
        if (!uploadedFiles.isEmpty()) {
            String incrementalUploadTime = AbstractBackupPath.formatDate(uploadedFiles.get(0).getTime());
            String metaFileName = "meta_" + backupDir.getParent() + "_" + incrementalUploadTime;
            logger.info("Uploading meta file for incremental backup: {}", (Object)metaFileName);
            this.metaData.setMetaFileName(metaFileName);
            this.metaData.set(uploadedFiles, incrementalUploadTime);
            logger.info("Uploaded meta file for incremental backup: {}", (Object)metaFileName);
        }
    }

    @Override
    protected void addToRemotePath(String remotePath) {
        this.incrementalRemotePaths.add(remotePath);
    }

    @Override
    public long getNumPendingFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getJobName() {
        return JOBNAME;
    }
}

