/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.IMessageObserver;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.utils.RetryableCallable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaData {
    private static final Logger logger = LoggerFactory.getLogger(MetaData.class);
    private final Provider<AbstractBackupPath> pathFactory;
    private static List<IMessageObserver> observers = new ArrayList<IMessageObserver>();
    private final List<String> metaRemotePaths = new ArrayList<String>();
    private final IBackupFileSystem fs;

    @Inject
    public MetaData(Provider<AbstractBackupPath> pathFactory, IFileSystemContext backupFileSystemCtx, IConfiguration config) {
        this.pathFactory = pathFactory;
        this.fs = backupFileSystemCtx.getFileStrategy(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBackupPath set(List<AbstractBackupPath> bps, String snapshotName) throws Exception {
        File metafile = this.createTmpMetaFile();
        try (FileWriter fr = new FileWriter(metafile);){
            JSONArray jsonObj = new JSONArray();
            for (AbstractBackupPath filePath : bps) {
                jsonObj.add((Object)filePath.getRemotePath());
            }
            fr.write(jsonObj.toJSONString());
        }
        AbstractBackupPath backupfile = this.decorateMetaJson(metafile, snapshotName);
        try {
            this.upload(backupfile);
            this.addToRemotePath(backupfile.getRemotePath());
            if (this.metaRemotePaths.size() > 0) {
                this.notifyObservers();
            }
        }
        finally {
            FileUtils.deleteQuietly((File)metafile);
        }
        return backupfile;
    }

    public AbstractBackupPath decorateMetaJson(File metafile, String snapshotName) throws ParseException {
        AbstractBackupPath backupfile = (AbstractBackupPath)this.pathFactory.get();
        backupfile.parseLocal(metafile, AbstractBackupPath.BackupFileType.META);
        backupfile.time = backupfile.parseDate(snapshotName);
        return backupfile;
    }

    public Boolean doesExist(final AbstractBackupPath meta) {
        try {
            new RetryableCallable<Void>(){

                @Override
                public Void retriableCall() throws Exception {
                    MetaData.this.fs.download(meta, new FileOutputStream(meta.newRestoreFile()));
                    return null;
                }
            }.call();
        }
        catch (Exception e) {
            logger.error("Error downloading the Meta data try with a different date...", (Throwable)e);
        }
        return meta.newRestoreFile().exists();
    }

    private void upload(final AbstractBackupPath bp) throws Exception {
        new RetryableCallable<Void>(){

            @Override
            public Void retriableCall() throws Exception {
                MetaData.this.fs.upload(bp, bp.localReader());
                return null;
            }
        }.call();
        bp.setCompressedFileSize(this.fs.getBytesUploaded());
    }

    public File createTmpMetaFile() throws IOException {
        File metafile = File.createTempFile("meta", ".json");
        File destFile = new File(metafile.getParent(), "meta.json");
        if (destFile.exists()) {
            destFile.delete();
        }
        FileUtils.moveFile((File)metafile, (File)destFile);
        return destFile;
    }

    public static void addObserver(IMessageObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(IMessageObserver observer) {
        observers.remove(observer);
    }

    private void notifyObservers() {
        for (IMessageObserver observer : observers) {
            if (observer != null) {
                logger.debug("Updating snapshot observers now ...");
                observer.update(IMessageObserver.BACKUP_MESSAGE_TYPE.META, this.metaRemotePaths);
                continue;
            }
            logger.info("Observer is Null, hence can not notify ...");
        }
    }

    private void addToRemotePath(String remotePath) {
        this.metaRemotePaths.add(remotePath);
    }

    public List<AbstractBackupPath> toJson(File input) {
        ArrayList files = Lists.newArrayList();
        try {
            JSONArray jsonObj = (JSONArray)new JSONParser().parse((Reader)new FileReader(input));
            for (int i = 0; i < jsonObj.size(); ++i) {
                AbstractBackupPath p = (AbstractBackupPath)this.pathFactory.get();
                p.parseRemote((String)jsonObj.get(i));
                files.add(p);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error transforming file " + input.getAbsolutePath() + " to JSON format.  Msg:" + ex.getLocalizedMessage(), ex);
        }
        logger.debug("Transformed file {} to JSON.  Number of JSON elements: {}", (Object)input.getAbsolutePath(), (Object)files.size());
        return files;
    }
}

