/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.utils.RetryableCallable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeReadInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(RangeReadInputStream.class);
    private final AmazonS3 s3Client;
    private final String bucketName;
    private final AbstractBackupPath path;
    private long offset;

    public RangeReadInputStream(AmazonS3 s3Client, String bucketName, AbstractBackupPath path) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.path = path;
    }

    @Override
    public int read(final byte[] b, final int off, int len) throws IOException {
        long fileSize = this.path.getSize();
        if (fileSize > 0L && this.offset >= fileSize) {
            return -1;
        }
        final long firstByte = this.offset;
        long curEndByte = firstByte + (long)len;
        curEndByte = curEndByte <= fileSize ? curEndByte : fileSize;
        final long endByte = curEndByte - 1L;
        try {
            Integer cnt = (Integer)new RetryableCallable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer retriableCall() throws IOException {
                    int readTotal;
                    S3ObjectInputStream is;
                    block4: {
                        Integer n;
                        GetObjectRequest req = new GetObjectRequest(RangeReadInputStream.this.bucketName, RangeReadInputStream.this.path.getRemotePath());
                        req.setRange(firstByte, endByte);
                        is = null;
                        try {
                            int rCnt;
                            is = RangeReadInputStream.this.s3Client.getObject(req).getObjectContent();
                            byte[] readBuf = new byte[4092];
                            readTotal = 0;
                            int incomingOffet = off;
                            while ((rCnt = is.read(readBuf, 0, readBuf.length)) >= 0) {
                                System.arraycopy(readBuf, 0, b, incomingOffet, rCnt);
                                readTotal += rCnt;
                                incomingOffet += rCnt;
                            }
                            if (readTotal != 0 || rCnt != -1) break block4;
                            n = -1;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        return n;
                    }
                    RangeReadInputStream.this.offset = RangeReadInputStream.this.offset + (long)readTotal;
                    Integer n = readTotal;
                    IOUtils.closeQuietly((InputStream)is);
                    return n;
                }
            }.call();
            return cnt;
        }
        catch (Exception e) {
            String msg = String.format("failed to read offset range %d-%d of file %s whose size is %d", firstByte, endByte, this.path.getRemotePath(), this.path.getSize());
            throw new IOException(msg, e);
        }
    }

    @Override
    public int read() throws IOException {
        logger.warn("read() called RangeReadInputStream");
        return -1;
    }
}

