/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.netflix.priam.backup.AbstractBackup;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.BackupRestoreUtil;
import com.netflix.priam.backup.IBackupStatusMgr;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.IMessageObserver;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.CassandraOperations;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.scheduler.CronTimer;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.CassandraMonitor;
import com.netflix.priam.utils.ThreadSleeper;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SnapshotBackup
extends AbstractBackup {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotBackup.class);
    public static final String JOBNAME = "SnapshotBackup";
    private final MetaData metaData;
    private final List<String> snapshotRemotePaths = new ArrayList<String>();
    private static List<IMessageObserver> observers = new ArrayList<IMessageObserver>();
    private final ThreadSleeper sleeper = new ThreadSleeper();
    private static final long WAIT_TIME_MS = 600000L;
    private InstanceIdentity instanceIdentity;
    private IBackupStatusMgr snapshotStatusMgr;
    private BackupRestoreUtil backupRestoreUtil;
    private String snapshotName = null;
    private List<AbstractBackupPath> abstractBackupPaths = null;
    private CassandraOperations cassandraOperations;

    @Inject
    public SnapshotBackup(IConfiguration config, Provider<AbstractBackupPath> pathFactory, MetaData metaData, IFileSystemContext backupFileSystemCtx, IBackupStatusMgr snapshotStatusMgr, InstanceIdentity instanceIdentity, CassandraOperations cassandraOperations) {
        super(config, backupFileSystemCtx, pathFactory);
        this.metaData = metaData;
        this.snapshotStatusMgr = snapshotStatusMgr;
        this.instanceIdentity = instanceIdentity;
        this.cassandraOperations = cassandraOperations;
        this.backupRestoreUtil = new BackupRestoreUtil(config.getSnapshotKeyspaceFilters(), config.getSnapshotCFFilter());
    }

    @Override
    public void execute() throws Exception {
        while (!CassandraMonitor.hasCassadraStarted().booleanValue()) {
            logger.debug("Cassandra has not yet started, hence Snapshot Backup will start after [600] secs ...");
            this.sleeper.sleep(600000L);
        }
        Date startTime = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
        AbstractBackupPath cfr_ignored_0 = (AbstractBackupPath)this.pathFactory.get();
        this.snapshotName = AbstractBackupPath.formatDate(startTime);
        String token = this.instanceIdentity.getInstance().getToken();
        BackupMetadata backupMetadata = new BackupMetadata(token, startTime);
        this.snapshotStatusMgr.start(backupMetadata);
        try {
            logger.info("Starting snapshot {}", (Object)this.snapshotName);
            this.snapshotRemotePaths.clear();
            this.cassandraOperations.takeSnapshot(this.snapshotName);
            this.abstractBackupPaths = Lists.newArrayList();
            this.initiateBackup("snapshots", this.backupRestoreUtil);
            File tmpMetaFile = this.metaData.createTmpMetaFile();
            AbstractBackupPath metaJsonAbp = this.metaData.decorateMetaJson(tmpMetaFile, this.snapshotName);
            AbstractBackupPath metaJson = this.metaData.set(this.abstractBackupPaths, this.snapshotName);
            logger.info("Snapshot upload complete for {}", (Object)this.snapshotName);
            backupMetadata.setSnapshotLocation(this.config.getBackupPrefix() + File.separator + metaJson.getRemotePath());
            this.snapshotStatusMgr.finish(backupMetadata);
            if (this.snapshotRemotePaths.size() > 0) {
                this.notifyObservers();
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while taking snapshot: {}. Exception: {}", (Object)this.snapshotName, (Object)e.getLocalizedMessage());
            this.snapshotStatusMgr.failed(backupMetadata);
            throw e;
        }
        finally {
            try {
                this.cassandraOperations.clearSnapshot(this.snapshotName);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private File getValidSnapshot(File snpDir, String snapshotName) {
        for (File snapshotDir : snpDir.listFiles()) {
            if (!snapshotDir.getName().matches(snapshotName)) continue;
            return snapshotDir;
        }
        return null;
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static boolean isBackupEnabled(IConfiguration config) throws Exception {
        return SnapshotBackup.getTimer(config) != null;
    }

    public static TaskTimer getTimer(IConfiguration config) throws Exception {
        CronTimer cronTimer = null;
        switch (config.getBackupSchedulerType()) {
            case HOUR: {
                if (config.getBackupHour() < 0) {
                    logger.info("Skipping {} as it is disabled via backup hour: {}", (Object)JOBNAME, (Object)config.getBackupHour());
                    break;
                }
                cronTimer = new CronTimer(JOBNAME, config.getBackupHour(), 1, 0);
                logger.info("Starting snapshot backup with backup hour: {}", (Object)config.getBackupHour());
                break;
            }
            case CRON: {
                cronTimer = CronTimer.getCronTimer(JOBNAME, config.getBackupCronExpression());
            }
        }
        return cronTimer;
    }

    public static void addObserver(IMessageObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(IMessageObserver observer) {
        observers.remove(observer);
    }

    private void notifyObservers() {
        for (IMessageObserver observer : observers) {
            if (observer != null) {
                logger.debug("Updating snapshot observers now ...");
                observer.update(IMessageObserver.BACKUP_MESSAGE_TYPE.SNAPSHOT, this.snapshotRemotePaths);
                continue;
            }
            logger.info("Observer is Null, hence can not notify ...");
        }
    }

    @Override
    protected void processColumnFamily(String keyspace, String columnFamily, File backupDir) throws Exception {
        File snapshotDir = this.getValidSnapshot(backupDir, this.snapshotName);
        if (null != snapshotDir) {
            this.abstractBackupPaths.addAll(this.upload(snapshotDir, AbstractBackupPath.BackupFileType.SNAP));
        } else {
            logger.warn("{} folder does not contain {} snapshots", (Object)backupDir, (Object)this.snapshotName);
        }
    }

    @Override
    protected void addToRemotePath(String remotePath) {
        this.snapshotRemotePaths.add(remotePath);
    }
}

